/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@WebSudoRequired
public class ApplicationAccess
extends JiraWebActionSupport {
    private static final String DEFAPP_LOCATION = "webpanels.admin.defaultapp.selector";
    private final PageBuilderService pageBuilder;
    private final HelpUrls helpUrls;
    private final DynamicWebInterfaceManager dynamicWebInterfaceManager;

    public ApplicationAccess(PageBuilderService pageBuilder, HelpUrls helpUrls, DynamicWebInterfaceManager dynamicWebInterfaceManager) {
        this.pageBuilder = pageBuilder;
        this.helpUrls = helpUrls;
        this.dynamicWebInterfaceManager = dynamicWebInterfaceManager;
    }

    protected String doExecute() {
        this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:application-roles");
        this.pageBuilder.assembler().data().requireData("com.atlassian.jira.web.action.admin.application-access:upgrade-jira-url", this.helpUrls.getUrl("upgrading").getUrl());
        this.pageBuilder.assembler().data().requireData("com.atlassian.jira.web.action.admin.application-access:defapp-selector-webpanels", this.renderPanel(DEFAPP_LOCATION, (ImmutableMap<String, Object>)ImmutableMap.of()));
        return "success";
    }

    @ActionViewDataMappings(value={"success"})
    public Map<String, Object> getDataMap() {
        return ImmutableMap.of((Object)"helpLinks", (Object)ImmutableList.of(this.getLink("application_access"), this.getLink("user_management.groups")));
    }

    private ImmutableMap<String, String> getLink(String key) {
        HelpUrl helpUrl = this.helpUrls.getUrl(key);
        return ImmutableMap.of((Object)"description", (Object)helpUrl.getDescription(), (Object)"title", (Object)helpUrl.getTitle(), (Object)"url", (Object)helpUrl.getUrl());
    }

    private String renderPanel(String location, ImmutableMap<String, Object> context) {
        return (String)SafePluginPointAccess.call(() -> {
            List panels = this.dynamicWebInterfaceManager.getDisplayableWebPanels(location, (Map)ImmutableMap.of());
            return SafePluginPointAccess.to().modules((Iterable)panels, (descriptor, webPanel) -> webPanel.getHtml((Map)context)).stream().collect(Collectors.joining());
        }).getOrElse((Object)"");
    }
}

