/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.PluggableTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import webwork.action.ActionContext;

public abstract class AbstractPluggableTabPanelAction<TabPanelClass extends PluggableTabPanelModuleDescriptor>
extends IssueActionSupport {
    protected final PluginAccessor pluginAccessor;
    private List<TabPanelClass> tabPanels;
    private String persistenceKey;

    public AbstractPluggableTabPanelAction(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.persistenceKey = AbstractPluggableTabPanelAction.class.toString();
    }

    public List<TabPanelClass> getTabPanels() {
        if (this.tabPanels == null) {
            this.tabPanels = this.initTabPanels();
        }
        return this.tabPanels;
    }

    protected List<TabPanelClass> initTabPanels() {
        List<TabPanelClass> tabPanels = this.getTabPanelModuleDescriptors();
        ArrayList filteredTabPanels = Lists.newArrayList((Iterable)Iterables.filter(tabPanels, (Predicate)new Predicate<TabPanelClass>(){

            public boolean apply(@Nullable TabPanelClass tabPanelClass) {
                try {
                    if (tabPanelClass == null) {
                        return false;
                    }
                    if (AbstractPluggableTabPanelAction.this.isTabPanelHidden(tabPanelClass)) {
                        return false;
                    }
                }
                catch (PermissionException e) {
                    return false;
                }
                return true;
            }
        }));
        Collections.sort(filteredTabPanels, ModuleDescriptorComparator.COMPARATOR);
        return filteredTabPanels;
    }

    protected abstract List<TabPanelClass> getTabPanelModuleDescriptors();

    protected abstract boolean isTabPanelHidden(TabPanelClass var1) throws PermissionException;

    protected boolean canSeeTab(String tabKey) {
        if (tabKey == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(tabKey, ":");
        if (st.countTokens() == 2) {
            st.nextToken();
            String tabName = st.nextToken();
            for (PluggableTabPanelModuleDescriptor tabPanel : this.getTabPanels()) {
                if (tabName == null || !tabName.equals(tabPanel.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public TabPanelClass getSelectedTabPanel() {
        return (TabPanelClass)((PluggableTabPanelModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(this.getSelectedTab()));
    }

    public String getSelected() {
        return this.getSelectedTab();
    }

    protected String getSelectedTab() {
        String currentKey = (String)this.getSession().get(this.persistenceKey);
        if (this.canSeeTab(currentKey)) {
            return currentKey;
        }
        List<TabPanelClass> projectTabPanels = this.getTabPanels();
        if (!projectTabPanels.isEmpty()) {
            String key = ((PluggableTabPanelModuleDescriptor)projectTabPanels.get(0)).getCompleteKey();
            this.setSelectedTab(key);
            return key;
        }
        return null;
    }

    public void setSelectedTab(String selectedTab) {
        this.getSession().put(this.persistenceKey, selectedTab);
    }

    private Map<String, Object> getSession() {
        return ActionContext.getSession();
    }

    public void setPersistenceKey(@Nonnull String persistenceKey) {
        this.persistenceKey = persistenceKey;
    }
}

