/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldVisibilityManagerImpl
implements FieldVisibilityManager {
    private static final Logger log = LoggerFactory.getLogger(FieldVisibilityManagerImpl.class);
    private final FieldManager fieldManager;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final SubTaskManager subTaskManager;

    @Deprecated
    public FieldVisibilityManagerImpl(FieldManager fieldManager, ProjectManager projectManager) {
        this(fieldManager, projectManager, ComponentAccessor.getConstantsManager(), ComponentAccessor.getFieldLayoutManager(), ComponentAccessor.getSubTaskManager());
    }

    public FieldVisibilityManagerImpl(FieldManager fieldManager, ProjectManager projectManager, ConstantsManager constantsManager, FieldLayoutManager fieldLayoutManager, SubTaskManager subTaskManager) {
        this.fieldManager = fieldManager;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.subTaskManager = subTaskManager;
    }

    public boolean isFieldHidden(ApplicationUser remoteUser, String id) {
        return this.fieldManager.isFieldHidden(remoteUser, id);
    }

    public boolean isFieldVisible(ApplicationUser remoteUser, String id) {
        return !this.fieldManager.isFieldHidden(remoteUser, id);
    }

    public boolean isFieldHidden(String fieldId, Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        Long projectId = issue.getProjectId();
        String issueTypeId = issue.getIssueTypeId();
        if (issueTypeId == null) {
            log.warn("Issue with id '" + issue.getId() + "' and key '" + issue.getKey() + "' has a null issue type, returning true for isFieldHidden check.");
            return true;
        }
        if (projectId == null) {
            log.warn("Issue with id '" + issue.getId() + "' and key '" + issue.getKey() + "' has a null project, returning true for isFieldHidden check.");
            return true;
        }
        return this.isFieldHidden(projectId, fieldId, issueTypeId);
    }

    public boolean isFieldVisible(String fieldId, Issue issue) {
        return !this.isFieldHidden(fieldId, issue);
    }

    public boolean isCustomFieldHidden(Long projectId, Long customFieldId, String issueTypeId) {
        return this.isFieldHidden(projectId, "customfield_" + customFieldId, issueTypeId);
    }

    public boolean isCustomFieldVisible(Long projectId, Long customFieldId, String issueTypeId) {
        return this.isFieldVisible(projectId, "customfield_" + customFieldId, issueTypeId);
    }

    public boolean isFieldHidden(Long projectId, String fieldId, Long issueTypeId) {
        return this.isFieldHidden(projectId, fieldId, issueTypeId.toString());
    }

    public boolean isFieldVisible(Long projectId, String fieldId, Long issueTypeId) {
        return this.isFieldVisible(projectId, fieldId, issueTypeId.toString());
    }

    public boolean isFieldHidden(Long projectId, String fieldId, String issueTypeId) {
        if (projectId == null) {
            throw new IllegalArgumentException("projectId cannot be null.");
        }
        if (TextUtils.stringSet((String)issueTypeId)) {
            if ("all".equals(issueTypeId)) {
                List issueTypes = this.subTaskManager.isSubTasksEnabled() ? this.constantsManager.expandIssueTypeIds((Collection)Lists.newArrayList((Object[])new String[]{"-4"})) : this.constantsManager.expandIssueTypeIds((Collection)Lists.newArrayList((Object[])new String[]{"-2"}));
                for (String issueType : issueTypes) {
                    FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(projectId, issueType);
                    if (fieldLayout != null && !fieldLayout.isFieldHidden(fieldId)) continue;
                    return true;
                }
                return false;
            }
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(projectId, issueTypeId);
            return fieldLayout == null || fieldLayout.isFieldHidden(fieldId);
        }
        log.warn("Unable to determine field visibility with project with id '" + projectId + "', issue type with id '" + issueTypeId + "' and field with id '" + fieldId + "'.");
        return true;
    }

    public boolean isFieldVisible(Long projectId, String fieldId, String issueTypeId) {
        return !this.isFieldHidden(projectId, fieldId, issueTypeId);
    }

    public boolean isFieldHiddenInAllSchemes(Long projectId, String fieldId, List<String> issueTypes) {
        if (projectId == null) {
            throw new IllegalArgumentException("projectId cannot be null");
        }
        if (issueTypes == null || issueTypes.isEmpty()) {
            issueTypes = this.subTaskManager.isSubTasksEnabled() ? this.constantsManager.expandIssueTypeIds((Collection)Lists.newArrayList((Object[])new String[]{"-4"})) : this.constantsManager.expandIssueTypeIds((Collection)Lists.newArrayList((Object[])new String[]{"-2"}));
        }
        FieldConfigurationScheme fieldConfigurationScheme = this.fieldLayoutManager.getFieldConfigurationSchemeForProject(projectId);
        HashSet<Long> fieldLayoutIds = new HashSet<Long>();
        if (fieldConfigurationScheme == null) {
            fieldLayoutIds.add(null);
        } else {
            for (String issueType : issueTypes) {
                fieldLayoutIds.add(fieldConfigurationScheme.getFieldLayoutId(issueType));
            }
        }
        for (Long fieldLayoutId : fieldLayoutIds) {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(fieldLayoutId);
            if (fieldLayout == null || fieldLayout.isFieldHidden(fieldId)) continue;
            return false;
        }
        return true;
    }

    public boolean isFieldHiddenInAllSchemes(Long projectId, String fieldId) {
        return this.isFieldHiddenInAllSchemes(projectId, fieldId, Collections.emptyList());
    }

    public boolean isFieldHiddenInAllSchemes(String fieldId, SearchContext context, ApplicationUser user) {
        if (context.isForAnyProjects()) {
            return this.isFieldHidden(user, fieldId);
        }
        List projectIds = context.getProjectIds();
        for (Long projectId : projectIds) {
            if (this.projectManager.getProjectObj(projectId) != null) {
                boolean hidden = this.isFieldHiddenInAllSchemes(projectId, fieldId, context.getIssueTypeIds());
                if (hidden) continue;
                return false;
            }
            log.warn("Unable to find project with id " + projectId);
        }
        return true;
    }
}

