/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import com.atlassian.jira.util.IOUtil;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseInfo {
    private static final Logger log = LoggerFactory.getLogger(ReleaseInfo.class);
    private static final String FILE_NAME = "release.info";
    private final String releaseInfo;
    private final boolean infoSet;

    public static ReleaseInfo getReleaseInfo(Class whereToLook) {
        try {
            InputStream resourceStream = whereToLook.getResourceAsStream(FILE_NAME);
            if (resourceStream == null) {
                return new ReleaseInfo("unknown", false);
            }
            StringWriter writer = new StringWriter();
            IOUtil.copy(resourceStream, (Writer)writer);
            return new ReleaseInfo(writer.toString(), true);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new ReleaseInfo("Could not get release info: " + e.toString(), false);
        }
    }

    private ReleaseInfo(String releaseInfo, boolean infoSet) {
        this.releaseInfo = releaseInfo;
        this.infoSet = infoSet;
    }

    public String getInfo() {
        return this.releaseInfo;
    }

    public boolean hasInfo() {
        return this.infoSet;
    }
}

