/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.cache;

import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public class CompositeKeyCache<R, S, T> {
    private final InternalCache cache;

    public static <R, S, T> CompositeKeyCache<R, S, T> createWeakFirstKeySoftValueCache(String cacheName) {
        return new CompositeKeyCache<R, S, T>(cacheName);
    }

    @Deprecated
    public static <R, S, T> CompositeKeyCache<R, S, T> createWeakFirstKeySoftValueCache() {
        return CompositeKeyCache.createWeakFirstKeySoftValueCache(null);
    }

    CompositeKeyCache(String cacheName) {
        this.cache = new InternalCache(cacheName);
    }

    public T get(@Nonnull R one, @Nonnull S two, Supplier<T> supplier) {
        return (T)this.cache.get(one).get(new Key<S, T>(two, supplier));
    }

    static final class Key<S, T>
    implements Supplier<T> {
        private final S two;
        private volatile Supplier<T> valueSupplier;

        public Key(S two, Supplier<T> valueSupplier) {
            this.two = Assertions.notNull((String)"two", two);
            this.valueSupplier = (Supplier)Assertions.notNull((String)"valueSupplier", valueSupplier);
        }

        public T get() {
            if (this.valueSupplier == null) {
                throw new IllegalStateException("reference has been cleared already");
            }
            return (T)this.valueSupplier.get();
        }

        public S getTwo() {
            return this.two;
        }

        void clearReference() {
            this.valueSupplier = null;
        }

        public int hashCode() {
            int prime = 31;
            boolean result = true;
            return 31 + (this.two == null ? 0 : this.two.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.two.equals(((Key)obj).two);
        }
    }

    static class ValueMap<S, T>
    implements Function<Key<S, T>, T> {
        private final LoadingCache<Key<S, T>, T> innerCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Key<S, T>, T>(){

            public T load(Key<S, T> from) {
                return from.get();
            }
        });

        ValueMap() {
        }

        public T get(Key<S, T> key) {
            try {
                Object object = this.innerCache.get(key);
                return (T)object;
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            finally {
                key.clearReference();
            }
        }
    }

    private class InternalCache
    implements Function<R, Function<Key<S, T>, T>> {
        private final LoadingCache<R, Function<Key<S, T>, T>> innerCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<R, Function<Key<S, T>, T>>(){

            public Function<Key<S, T>, T> load(R key) throws Exception {
                return new ValueMap();
            }
        });

        InternalCache(String cacheName) {
            if (cacheName != null) {
                new GoogleCacheInstruments(cacheName + "." + InternalCache.class.getSimpleName()).addCache((Cache)this.innerCache).install();
            }
        }

        public Function<Key<S, T>, T> get(R from) {
            try {
                return (Function)this.innerCache.get(from);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

