/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.util.DateFieldFormat;
import java.util.Date;

public class DateFieldFormatImpl
implements DateFieldFormat {
    private final DateTimeFormatter dateFormatter;
    private final DateTimeFormatter datePickerFormatter;

    public DateFieldFormatImpl(DateTimeFormatterFactory dateTimeFormatterFactory) {
        DateTimeFormatter systemTimeZoneFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser().withSystemZone();
        this.dateFormatter = systemTimeZoneFormatter.withStyle(DateTimeStyle.DATE);
        this.datePickerFormatter = systemTimeZoneFormatter.withStyle(DateTimeStyle.DATE_PICKER);
    }

    public String format(Date date) {
        return this.dateFormatter.format(date);
    }

    public String formatDatePicker(Date date) {
        return this.datePickerFormatter.format(date);
    }

    public Date parseDatePicker(String text) throws IllegalArgumentException {
        return this.datePickerFormatter.parse(text);
    }

    public boolean isParseable(String releaseDate) {
        try {
            this.parseDatePicker(releaseDate);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String getFormatHint() {
        return this.datePickerFormatter.getFormatHint();
    }
}

