/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.flag;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.util.Clock;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.flag.FlagDismissalService;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.collect.Sets;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagDismissalServiceImpl
implements FlagDismissalService {
    private static final String DISMISSALS_KEY = "com.atlassian.jira.flag.dismissals";
    private static final String RESETS_KEY = "com.atlassian.jira.flag.resets";
    private final UserPreferencesManager userPreferencesManager;
    private final JiraPropertySetFactory jiraPropertySetFactory;
    private final Clock clock;
    private static final Logger log = LoggerFactory.getLogger(FlagDismissalServiceImpl.class);

    public FlagDismissalServiceImpl(UserPreferencesManager userPreferencesManager, JiraPropertySetFactory jiraPropertySetFactory, Clock clock) {
        this.userPreferencesManager = userPreferencesManager;
        this.jiraPropertySetFactory = jiraPropertySetFactory;
        this.clock = clock;
    }

    public void dismissFlagForUser(String flagKey, ApplicationUser user) {
        if (user == null || StringUtils.isBlank((CharSequence)flagKey)) {
            return;
        }
        JSONObject dismissals = this.getDismissalsForUser(user);
        try {
            dismissals.put(flagKey, this.clock.getCurrentDate().getTime());
            this.setDismissalsForUser(user, dismissals);
        }
        catch (JSONException e) {
            log.debug("Exception occurred while trying to dismiss flag:", (Throwable)e);
        }
    }

    public void resetFlagDismissals(String flagKey) {
        JSONObject resets = this.getDismissalResets();
        try {
            resets.put(flagKey, this.clock.getCurrentDate().getTime());
            this.getPropertySet().setText(RESETS_KEY, resets.toString());
        }
        catch (JSONException e) {
            log.debug("Exception occurred while trying reset flag dismissal:", (Throwable)e);
        }
    }

    public Set<String> getDismissedFlagsForUser(ApplicationUser user) {
        JSONObject userDismissalData = this.getDismissalsForUser(user);
        try {
            HashSet currentDismissals = Sets.newHashSet();
            Iterator dismissedKeys = userDismissalData.keys();
            JSONObject resetTimes = this.getDismissalResets();
            while (dismissedKeys.hasNext()) {
                String dismissedFlag = (String)dismissedKeys.next();
                long lastDismissal = userDismissalData.getLong(dismissedFlag);
                if (resetTimes.has(dismissedFlag) && resetTimes.getLong(dismissedFlag) >= lastDismissal) continue;
                currentDismissals.add(dismissedFlag);
            }
            return currentDismissals;
        }
        catch (JSONException e) {
            log.debug("Exception occurred while trying to retrieve dismissed flags:", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private PropertySet getPropertySet() {
        return this.jiraPropertySetFactory.buildCachingDefaultPropertySet(this.getClass().getCanonicalName());
    }

    private JSONObject getDismissalResets() {
        String dismissalResets = this.getPropertySet().getText(RESETS_KEY);
        try {
            return StringUtils.isBlank((CharSequence)dismissalResets) ? new JSONObject() : new JSONObject(dismissalResets);
        }
        catch (JSONException e) {
            return new JSONObject();
        }
    }

    private JSONObject getDismissalsForUser(ApplicationUser user) {
        String dismissals = this.userPreferencesManager.getExtendedPreferences(user).getText(DISMISSALS_KEY);
        try {
            return StringUtils.isBlank((CharSequence)dismissals) ? new JSONObject() : new JSONObject(dismissals);
        }
        catch (JSONException e) {
            return new JSONObject();
        }
    }

    private void setDismissalsForUser(ApplicationUser user, JSONObject dismissals) {
        try {
            this.userPreferencesManager.getExtendedPreferences(user).setText(DISMISSALS_KEY, dismissals.toString());
        }
        catch (AtlassianCoreException e) {
            log.debug("Exception occurred while trying to dismiss flag:", (Throwable)e);
        }
    }
}

