/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.UserLocaleStore;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.LocaleParser;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Locale;
import javax.annotation.Nonnull;

public class PropertySetUserLocaleStore
implements UserLocaleStore {
    private final ApplicationProperties applicationProperties;
    private final UserPropertyManager userPropertyManager;
    private final UserKeyService userKeys;

    public PropertySetUserLocaleStore(ApplicationProperties applicationProperties, UserPropertyManager userPropertyManager, UserKeyService userKeys) {
        this.applicationProperties = applicationProperties;
        this.userPropertyManager = userPropertyManager;
        this.userKeys = userKeys;
    }

    @Nonnull
    public Locale getDefaultLocale() {
        return this.applicationProperties.getDefaultLocale();
    }

    @Nonnull
    public Locale getLocale(ApplicationUser user) {
        String keyForUser;
        if (!Users.isAnonymous((ApplicationUser)user) && (keyForUser = user.getKey()) != null) {
            try {
                return this.getLocaleFromUserPropertySet(this.userPropertyManager.getPropertySetForUserKey(keyForUser));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.getDefaultLocale();
    }

    private Locale getLocaleFromUserPropertySet(PropertySet propertySet) {
        Locale locale;
        if (propertySet != null && (locale = LocaleParser.parseLocale((String)propertySet.getString("jira.user.locale"))) != null) {
            return locale;
        }
        return this.getDefaultLocale();
    }
}

