/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.jira.license.ServiceDeskLicenseConstants;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import javax.annotation.Nonnull;

final class LicenseUtils {
    private LicenseUtils() {
    }

    public static ServiceDeskLicenseType determineServiceDeskLicenseType(@Nonnull License license) {
        if (LicenseUtils.isServiceDeskLicense(license)) {
            String roleCountStr = license.productLicense().getProperty("com.atlassian.servicedesk.numRoleCount");
            if (roleCountStr != null || LicenseUtils.isRbpLicense(license)) {
                return ServiceDeskLicenseType.AgentBasedPricing;
            }
            return ServiceDeskLicenseType.TierBasedPricing;
        }
        throw new MigrationFailedException("Not a service desk license: " + license.toString());
    }

    public static boolean isServiceDeskLicense(@Nonnull License license) {
        return Boolean.parseBoolean(license.productLicense().getProperty("com.atlassian.servicedesk.active")) || LicenseUtils.isRbpLicense(license);
    }

    private static boolean isRbpLicense(@Nonnull License license) {
        return Boolean.parseBoolean(license.productLicense().getProperty(ServiceDeskLicenseConstants.SD_RBP_ACTIVE));
    }

    static enum ServiceDeskLicenseType {
        AgentBasedPricing,
        TierBasedPricing;

    }
}

