/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.index.request.ReindexRequestService;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public abstract class AbstractUpgradeTask
implements UpgradeTask {
    private final List<String> errors = new ArrayList<String>();

    protected static OfBizDelegator getOfBizDelegator() {
        return ComponentAccessor.getOfBizDelegator();
    }

    protected static EntityEngine getEntityEngine() {
        return (EntityEngine)ComponentAccessor.getComponent(EntityEngine.class);
    }

    static String ensureTablePrefixed(String tableName, String schemaName) {
        String prefix;
        if (StringUtils.isNotBlank((String)schemaName) && !tableName.startsWith(prefix = schemaName + ".")) {
            return prefix + tableName;
        }
        return tableName;
    }

    @Override
    public abstract String getBuildNumber();

    @Override
    public abstract void doUpgrade(boolean var1) throws Exception;

    @Override
    @Nullable
    public String dependsUpon() {
        return null;
    }

    @Deprecated
    protected GenericDelegator getDelegator() {
        return CoreFactory.getGenericDelegator();
    }

    protected ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    protected ReindexRequestService getReindexRequestService() {
        return (ReindexRequestService)ComponentAccessor.getComponent(ReindexRequestService.class);
    }

    protected void addError(String error) {
        this.errors.add(error);
    }

    public void addErrors(String prefix, Collection<String> errors) {
        for (String errorMessage : errors) {
            errors.add(prefix + errorMessage);
        }
    }

    public void addErrors(Collection<String> errors) {
        this.addErrors("", errors);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    protected Connection getDatabaseConnection() {
        try {
            GenericHelper helper = this.getDelegator().getEntityHelper("User");
            DatabaseUtil utils = new DatabaseUtil(helper.getHelperName());
            return utils.getConnection();
        }
        catch (SQLException | GenericEntityException ex) {
            throw new DataAccessException("Unable to obtain a DB connection", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DatabaseType getDatabaseType() {
        try (Connection connection = this.getDatabaseConnection();){
            DatabaseType databaseType = DatabaseTypeFactory.getTypeForConnection((Connection)connection);
            return databaseType;
        }
        catch (SQLException sqle) {
            throw new DataAccessException("Unable to obtain DB type", (Throwable)sqle);
        }
    }

    protected String convertToSchemaTableName(String tableName) {
        return AbstractUpgradeTask.ensureTablePrefixed(tableName, this.getSchemaName());
    }

    protected String getSchemaName() {
        try {
            GenericHelper helper = this.getDelegator().getEntityHelper("User");
            return EntityConfigUtil.getInstance().getDatasourceInfo(helper.getHelperName()).getSchemaName();
        }
        catch (GenericEntityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isDatabaseTypeForFieldType(String fieldType) {
        return this.getDatabaseType().getFieldTypeName().startsWith(fieldType);
    }

    protected boolean isORACLE() throws SQLException {
        return this.isDatabaseTypeForFieldType("oracle");
    }

    protected boolean isMSSQL() throws SQLException {
        return this.isDatabaseTypeForFieldType("mssql");
    }

    protected boolean isMYSQL() throws SQLException {
        return this.isDatabaseTypeForFieldType("mysql");
    }

    protected boolean isPostgreSQL() {
        return this.isDatabaseTypeForFieldType("postgres");
    }
}

