/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.template.TemplateSource;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.template.velocity.VelocityTemplateCache;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.velocity.VelocityManager;
import com.atlassian.velocity.htmlsafe.directive.DefaultDirectiveChecker;
import com.atlassian.velocity.htmlsafe.directive.DirectiveChecker;
import com.atlassian.velocity.htmlsafe.event.referenceinsertion.DisableHtmlEscapingDirectiveHandler;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.context.Context;

public class DefaultVelocityTemplatingEngine
implements VelocityTemplatingEngine {
    private final VelocityManager velocityManager;
    private final ApplicationProperties applicationProperties;
    private final DirectiveChecker directiveChecker;

    public DefaultVelocityTemplatingEngine(VelocityManager velocityManager, ApplicationProperties applicationProperties) {
        this(velocityManager, applicationProperties, null);
    }

    public DefaultVelocityTemplatingEngine(VelocityManager velocityManager, ApplicationProperties applicationProperties, @Nullable VelocityTemplateCache velocityTemplateCache) {
        this.velocityManager = velocityManager;
        this.applicationProperties = applicationProperties;
        this.directiveChecker = velocityTemplateCache == null ? new DefaultDirectiveChecker() : new CachingDirectiveChecker(velocityTemplateCache);
    }

    public VelocityTemplatingEngine.RenderRequest render(TemplateSource source) {
        return new DefaultRenderRequest(source);
    }

    private EventCartridge createDefaultCartridge() {
        EventCartridge cartridge = new EventCartridge();
        DisableHtmlEscapingDirectiveHandler handler = new DisableHtmlEscapingDirectiveHandler();
        handler.setDirectiveChecker(this.directiveChecker);
        cartridge.addEventHandler((EventHandler)handler);
        return cartridge;
    }

    private static class CachingDirectiveChecker
    implements DirectiveChecker {
        private final VelocityTemplateCache velocityTemplateCache;

        public CachingDirectiveChecker(@Nonnull VelocityTemplateCache velocityTemplateCache) {
            this.velocityTemplateCache = velocityTemplateCache;
        }

        public boolean isPresent(String directiveName, Template template) {
            return this.velocityTemplateCache.isDirectivePresent(directiveName, template);
        }
    }

    class DefaultRenderRequest
    implements VelocityTemplatingEngine.RenderRequest {
        private final TemplateSource source;
        private VelocityContext context = this.createContextFrom(Collections.emptyMap());

        public DefaultRenderRequest(TemplateSource source) {
            Assertions.notNull((Object)source);
            this.source = source;
        }

        public VelocityTemplatingEngine.RenderRequest applying(Map<String, Object> parameters) {
            this.context = this.createContextFrom(parameters);
            return this;
        }

        public VelocityTemplatingEngine.RenderRequest applying(VelocityContext context) {
            this.context = context;
            return this;
        }

        public String asPlainText() {
            return new StringRepresentation(){

                @Override
                void with(StringWriter sw) throws IOException {
                    DefaultRenderRequest.this.asPlainText(sw);
                }
            }.toString();
        }

        public String asHtml() {
            return new StringRepresentation(){

                @Override
                void with(StringWriter sw) throws IOException {
                    DefaultRenderRequest.this.asHtml(sw);
                }
            }.toString();
        }

        public void asPlainText(Writer writer) throws IOException {
            this.toWriterImpl(writer, false);
        }

        public void asHtml(Writer writer) throws IOException {
            this.toWriterImpl(writer, true);
        }

        private void toWriterImpl(Writer writer, boolean attachCartridge) throws IOException {
            if (this.source instanceof TemplateSource.File) {
                TemplateSource.File template = (TemplateSource.File)this.source;
                if (attachCartridge) {
                    this.context.attachEventCartridge(DefaultVelocityTemplatingEngine.this.createDefaultCartridge());
                }
                DefaultVelocityTemplatingEngine.this.velocityManager.writeEncodedBody(writer, template.getPath(), "", DefaultVelocityTemplatingEngine.this.applicationProperties.getEncoding(), (Context)this.context);
            } else if (this.source instanceof TemplateSource.Fragment) {
                TemplateSource.Fragment fragment = (TemplateSource.Fragment)this.source;
                if (attachCartridge) {
                    this.context.attachEventCartridge(DefaultVelocityTemplatingEngine.this.createDefaultCartridge());
                }
                DefaultVelocityTemplatingEngine.this.velocityManager.writeEncodedBodyForContent(writer, fragment.getContent(), (Context)this.context);
            }
        }

        private String getBaseUrl() {
            if (ExecutingHttpRequest.get() != null) {
                return ExecutingHttpRequest.get().getContextPath();
            }
            return DefaultVelocityTemplatingEngine.this.applicationProperties.getString("jira.baseurl");
        }

        private VelocityContext createContextFrom(Map<String, Object> suppliedParameters) {
            Map contextParameters = CompositeMap.of(suppliedParameters, Collections.singletonMap("baseurl", this.getBaseUrl()));
            return new VelocityContext(CompositeMap.of((Map)Maps.newHashMap(), (Map)contextParameters));
        }

        private abstract class StringRepresentation {
            private StringRepresentation() {
            }

            public String toString() {
                try {
                    StringWriter sw = new StringWriter();
                    this.with(sw);
                    return sw.toString();
                }
                catch (IOException e) {
                    return "";
                }
            }

            abstract void with(StringWriter var1) throws IOException;
        }
    }
}

