/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.bc.dataimport.ExportService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmbeddedDatabaseMigrator
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(EmbeddedDatabaseMigrator.class);
    private static final String EXPORT_FILENAME = "hsql-migration.zip";
    private static final String DBCONFIG_FILENAME = "dbconfig.xml";
    private static final String DBCONFIG_BAKCUP_FILENAME = "dbconfig.xml.hsql";
    private final JiraProperties jiraSystemProperties;
    private final JohnsonProvider johnsonProvider;
    private final ComponentReference<DatabaseConfigurationManager> dbcmRef = ComponentAccessor.getComponentReference(DatabaseConfigurationManager.class);

    public EmbeddedDatabaseMigrator(JiraProperties jiraSystemProperties, JohnsonProvider johnsonProvider) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.johnsonProvider = johnsonProvider;
    }

    @Override
    public void start() {
        DatabaseConfig databaseConfig = ((DatabaseConfigurationManager)this.dbcmRef.get()).getDatabaseConfiguration();
        if (databaseConfig.isEmbeddedDatabase()) {
            if (databaseConfig.isHSql()) {
                this.exportAndHalt();
            } else if (this.exportFile().exists()) {
                this.importAndContinue();
            }
        }
    }

    @Override
    public void stop() {
    }

    private void exportAndHalt() {
        log.info((Object)"Starting legacy HSQL embedded database export");
        DatabaseConfigurationManager dbcm = (DatabaseConfigurationManager)this.dbcmRef.get();
        String exportFileName = this.exportFile().getAbsolutePath();
        ExportService exportService = (ExportService)ComponentAccessor.getComponent(ExportService.class);
        ServiceOutcome<Void> outcome = exportService.export(null, exportFileName, TaskProgressSink.NULL_SINK);
        if (!outcome.isValid()) {
            AtlassianCoreException e = new AtlassianCoreException(Joiner.on((String)"\n").join((Iterable)outcome.getErrorCollection().getErrorMessages()));
            throw new RuntimeException(e);
        }
        log.info((Object)("Finished legacy HSQL embedded database export: " + exportFileName));
        File dbConfigFile = this.dbConfigFile();
        File dbConfigBackupFile = this.dbConfigBackupFile();
        if (!dbConfigFile.renameTo(dbConfigBackupFile)) {
            throw new RuntimeException("unable to move " + dbConfigFile + " to " + dbConfigBackupFile);
        }
        log.info((Object)("Backed up HSQL database configuration: " + dbConfigBackupFile.getAbsolutePath()));
        DatabaseConfig internalDatabaseConfig = dbcm.getInternalDatabaseConfiguration();
        dbcm.setDatabaseConfiguration(internalDatabaseConfig);
        dbcm.activateDatabase();
        String restartMessage = "JIRA must be restarted to complete the import process";
        String stars = StringUtils.repeat((String)"*", (int)"JIRA must be restarted to complete the import process".length());
        String newLine = this.jiraSystemProperties.getProperty("line.separator");
        log.warn((Object)(newLine + newLine + stars + newLine + "JIRA must be restarted to complete the import process" + newLine + stars + newLine));
        EventType eventType = EventType.get((String)"database");
        Event event = new Event(eventType, "Please restart JIRA to complete the HSQL to H2 database migration", EventLevel.get((String)"fatal"));
        this.johnsonProvider.getContainer().addEvent(event);
    }

    private void importAndContinue() {
        DataImportService dataImportService = (DataImportService)ComponentAccessor.getComponent(DataImportService.class);
        File importFile = this.importFile();
        File exportFile = this.exportFile();
        log.info((Object)("Starting legacy HSQL embedded database import: " + exportFile.getAbsolutePath()));
        DataImportParams.Builder builder = new DataImportParams.Builder(exportFile.getAbsolutePath()).setupImport();
        DataImportParams params = builder.build();
        DataImportService.ImportValidationResult valResult = dataImportService.validateImport(null, params);
        DataImportService.ImportResult importResult = dataImportService.doImport(null, valResult, TaskProgressSink.NULL_SINK);
        if (!importResult.isValid()) {
            AtlassianCoreException e = new AtlassianCoreException(Joiner.on((String)"\n").join((Iterable)importResult.getErrorCollection().getErrorMessages()));
            throw new RuntimeException(e);
        }
        log.info((Object)"Finished legacy HSQL embedded database import");
        try {
            Files.move(exportFile.toPath(), importFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to move " + exportFile + " to " + importFile);
        }
        log.info((Object)("moved legacy HSQL embedded database export to: " + importFile.getAbsolutePath()));
    }

    private File exportFile() {
        return new File(((JiraHome)ComponentAccessor.getComponent(JiraHome.class)).getExportDirectory().getAbsolutePath(), EXPORT_FILENAME);
    }

    private File importFile() {
        return new File(((JiraHome)ComponentAccessor.getComponent(JiraHome.class)).getImportDirectory().getAbsolutePath(), EXPORT_FILENAME);
    }

    private File dbConfigFile() {
        return new File(((JiraHome)ComponentAccessor.getComponent(JiraHome.class)).getHomePath(), DBCONFIG_FILENAME);
    }

    private File dbConfigBackupFile() {
        return new File(((JiraHome)ComponentAccessor.getComponent(JiraHome.class)).getHomePath(), DBCONFIG_BAKCUP_FILENAME);
    }
}

