/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.analytics.start;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.service.services.analytics.JiraAnalyticTask;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.system.SystemInfoUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;

public class JiraSystemAnalyticTask
implements JiraAnalyticTask {
    private BuildUtilsInfo info;
    private SystemInfoUtils systemInfoUtils;
    private ClusterManager clusterManager;
    private JiraProperties jiraProperties;

    public JiraSystemAnalyticTask() {
    }

    @VisibleForTesting
    JiraSystemAnalyticTask(BuildUtilsInfo info, SystemInfoUtils systemInfoUtils, ClusterManager clusterManager, JiraProperties jiraProperties) {
        this.info = info;
        this.systemInfoUtils = systemInfoUtils;
        this.clusterManager = clusterManager;
        this.jiraProperties = jiraProperties;
    }

    @Override
    public void init() {
        this.info = (BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class);
        this.systemInfoUtils = (SystemInfoUtils)ComponentAccessor.getComponent(SystemInfoUtils.class);
        this.clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        this.jiraProperties = (JiraProperties)ComponentAccessor.getComponent(JiraProperties.class);
    }

    @Override
    public Map<String, Object> getAnalytics() {
        MapBuilder builder = MapBuilder.newBuilder();
        int[] versionNumbers = this.info.getVersionNumbers();
        builder.add((Object)"release.version", (Object)versionNumbers[0]);
        builder.add((Object)"major.version", (Object)versionNumbers[1]);
        builder.add((Object)"minor.version", (Object)versionNumbers[2]);
        builder.add((Object)"build.number", (Object)this.info.getCurrentBuildNumber());
        builder.add((Object)"build.date", (Object)String.valueOf(this.info.getCurrentBuildDate()));
        builder.add((Object)"license.dc", (Object)this.clusterManager.isClusterLicensed());
        builder.add((Object)"java.specification.version", (Object)this.jiraProperties.getProperty("java.specification.version"));
        builder.add((Object)"java.version", (Object)this.jiraProperties.getProperty("java.version"));
        builder.add((Object)"java.vendor", (Object)this.jiraProperties.getProperty("java.vendor"));
        builder.add((Object)"os.name", (Object)this.jiraProperties.getProperty("os.name", "unknown"));
        builder.add((Object)"os.version", (Object)this.jiraProperties.getProperty("os.version", "unknown"));
        builder.add((Object)"os.arch", (Object)this.jiraProperties.getProperty("os.arch", "unknown"));
        builder.add((Object)"database.name", (Object)this.systemInfoUtils.getDatabaseType());
        try {
            SystemInfoUtils.DatabaseMetaData databaseMetaData = this.systemInfoUtils.getDatabaseMetaData();
            builder.add((Object)"database.version", (Object)databaseMetaData.getDatabaseProductVersion());
            builder.add((Object)"database.driver.version", (Object)databaseMetaData.getDriverVersion());
        }
        catch (Exception e) {
            builder.add((Object)"database.version", (Object)"unknown");
            builder.add((Object)"database.driver.version", (Object)"unknown");
        }
        return builder.toMap();
    }

    @Override
    public boolean isReportingDataShape() {
        return false;
    }
}

