/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractIssueFieldSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCF
extends AbstractIssueFieldSecurityType {
    public static final String TYPE = "userCF";
    private static final Logger log = LoggerFactory.getLogger(UserCF.class);
    private JiraAuthenticationContext jiraAuthenticationContext;
    private final CustomFieldManager customFieldManager;

    public UserCF(JiraAuthenticationContext jiraAuthenticationContext, CustomFieldManager customFieldManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.user.custom.field");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void doValidation(String key, Map<String, String> parameters, JiraServiceContext jiraServiceContext) {
        String customFieldOption = parameters.get(this.getType());
        if (StringUtils.isEmpty((String)customFieldOption)) {
            String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.please.select.user.customfield");
            jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
        } else {
            CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldOption);
            if (customField != null && customField.getCustomFieldSearcher() == null) {
                String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.customfieldnotindexed", customField.getName());
                jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
            }
        }
    }

    @Override
    protected String getFieldName(String parameter) {
        return parameter;
    }

    @Override
    protected boolean hasProjectPermission(ApplicationUser user, boolean issueCreation, GenericValue project) {
        return !issueCreation;
    }

    @Override
    protected boolean hasProjectPermission(ApplicationUser user, boolean issueCreation, Project project) {
        return !issueCreation;
    }

    @Override
    protected boolean hasIssuePermission(ApplicationUser user, boolean issueCreation, GenericValue issueGv, String customFieldName) {
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        IssueFactory issueFactory = (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
        CustomField field = customFieldManager.getCustomFieldObject(customFieldName);
        if (field != null) {
            Set<ApplicationUser> values = this.convertToUserSet(this.getValuesFromIssue(field, (Issue)issueFactory.getIssue(issueGv)));
            return values.contains(user);
        }
        return false;
    }

    @Override
    protected boolean hasIssuePermission(ApplicationUser user, boolean issueCreation, Issue issue, String parameter) {
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        CustomField field = customFieldManager.getCustomFieldObject(parameter);
        if (field != null) {
            Set<ApplicationUser> values = this.convertToUserSet(this.getValuesFromIssue(field, issue));
            return values.contains(user);
        }
        return false;
    }

    public List<Field> getDisplayFields() {
        Set fieldSet;
        FieldManager fieldManager = this.getFieldManager();
        try {
            fieldSet = fieldManager.getAllAvailableNavigableFields();
        }
        catch (FieldException e) {
            return Collections.emptyList();
        }
        ArrayList fields = Lists.newArrayListWithCapacity((int)fieldSet.size());
        for (Field field : fieldSet) {
            CustomFieldType type;
            if (!fieldManager.isCustomField(field) || !((type = ((CustomField)field).getCustomFieldType()) instanceof UserCFType) && !(type instanceof MultiUserCFType)) continue;
            fields.add(field);
        }
        return fields;
    }

    @Override
    public String getArgumentDisplay(String argument) {
        CustomFieldManager fieldManager = ComponentAccessor.getCustomFieldManager();
        CustomField field = fieldManager.getCustomFieldObject(argument);
        return field != null ? field.getName() : argument;
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String customFieldId) {
        if (ctx.getIssue() == null) {
            log.debug("Could not retrieve users for UserCF '" + customFieldId + "' since provided PermissionContext has no issue.");
            return Collections.emptySet();
        }
        Issue issue = ctx.getIssue();
        FieldManager fieldManager = this.getFieldManager();
        CustomField field = fieldManager.getCustomField(customFieldId);
        return this.convertToUserSet(this.getValuesFromIssue(field, issue));
    }

    Object getValuesFromIssue(CustomField field, Issue issue) {
        return field.getCustomFieldType().getValueFromIssue(field, issue);
    }

    FieldManager getFieldManager() {
        return ComponentAccessor.getFieldManager();
    }

    Set<ApplicationUser> convertToUserSet(Object fieldValues) {
        if (fieldValues == null) {
            return Collections.emptySet();
        }
        if (fieldValues instanceof Collection) {
            Collection applicationUsers = (Collection)fieldValues;
            HashSet<ApplicationUser> users = new HashSet<ApplicationUser>(applicationUsers.size());
            for (ApplicationUser applicationUser : applicationUsers) {
                users.add(applicationUser);
            }
            return users;
        }
        ApplicationUser applicationUser = (ApplicationUser)fieldValues;
        return Collections.singleton(applicationUser);
    }
}

