/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginInfoImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.login.LoginStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginStoreImpl
implements LoginStore {
    private static final Logger log = LoggerFactory.getLogger(LoginStoreImpl.class);
    private static final String LAST_LOGIN_TIME = "login.lastLoginMillis";
    private static final String PREV_LOGIN_TIME = "login.previousLoginMillis";
    private static final String LAST_FAILED_TIME = "login.lastFailedLoginMillis";
    private static final String LOGIN_COUNT = "login.count";
    private static final String CURRENT_FAILED_COUNT = "login.currentFailedCount";
    private static final String TOTAL_FAILED_COUNT = "login.totalFailedCount";
    private final Clock clock;
    private final ApplicationProperties applicationProperties;
    private final CrowdService crowdService;

    public LoginStoreImpl(Clock clock, ApplicationProperties applicationProperties, CrowdService crowdService) {
        this.clock = (Clock)Assertions.notNull((String)"clock", (Object)clock);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.crowdService = (CrowdService)Assertions.notNull((String)"crowdService", (Object)crowdService);
    }

    @Override
    public LoginInfo recordLoginAttempt(ApplicationUser user, boolean authenticated) {
        Assertions.notNull((String)"user", (Object)user);
        UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getName());
        if (authenticated) {
            this.setLong((User)userWithAttributes, CURRENT_FAILED_COUNT, 0L);
            Long lastLoginTime = this.getLong(userWithAttributes, LAST_LOGIN_TIME);
            this.setLong((User)userWithAttributes, LAST_LOGIN_TIME, this.now());
            if (lastLoginTime != null) {
                this.setLong((User)userWithAttributes, PREV_LOGIN_TIME, lastLoginTime);
            }
            this.incrementLong(userWithAttributes, LOGIN_COUNT, 1);
        } else {
            this.setLong((User)userWithAttributes, LAST_FAILED_TIME, this.now());
            this.incrementLong(userWithAttributes, CURRENT_FAILED_COUNT, 1);
            this.incrementLong(userWithAttributes, TOTAL_FAILED_COUNT, 1);
        }
        return this.getLoginInfo(user);
    }

    @Override
    public long getMaxAuthenticationAttemptsAllowed() {
        String maxStr = this.applicationProperties.getDefaultBackedString("jira.maximum.authentication.attempts.allowed");
        try {
            return StringUtils.isBlank((String)maxStr) ? Long.MAX_VALUE : Long.parseLong(maxStr);
        }
        catch (NumberFormatException e) {
            log.error("Unable to read the MaxAuthenticationAttemptsAllowed value ' " + maxStr + "'. Defaulting to UNLIMITED. If you really care about security you will want to find out why this value cannot be read.");
            return Long.MAX_VALUE;
        }
    }

    @Override
    public void resetFailedLoginCount(ApplicationUser user) {
        this.setLong(user.getDirectoryUser(), CURRENT_FAILED_COUNT, 0L);
    }

    @Override
    public LoginInfo getLoginInfo(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getName());
        return this.getLoginInfoInternal(userWithAttributes);
    }

    private LoginInfo getLoginInfoInternal(UserWithAttributes userWithAttributes) {
        return LoginInfoImpl.builder().setLastLoginTime(this.getLong(userWithAttributes, LAST_LOGIN_TIME)).setPreviousLoginTime(this.getLong(userWithAttributes, PREV_LOGIN_TIME)).setLastFailedLoginTime(this.getLong(userWithAttributes, LAST_FAILED_TIME)).setLoginCount(this.getLong(userWithAttributes, LOGIN_COUNT)).setCurrentFailedLoginCount(this.getLong(userWithAttributes, CURRENT_FAILED_COUNT)).setTotalFailedLoginCount(this.getLong(userWithAttributes, TOTAL_FAILED_COUNT)).setMaxAuthenticationAttemptsAllowed(this.getMaxAuthenticationAttemptsAllowed()).setElevatedSecurityCheckRequired(false).build();
    }

    private void setLong(User user, String key, long value) {
        try {
            this.crowdService.setUserAttribute(user, key, Long.valueOf(value).toString());
        }
        catch (OperationNotPermittedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private Long getLong(UserWithAttributes userWithAttributes, String key) {
        String attribute = userWithAttributes.getValue(key);
        if (attribute != null) {
            return Long.valueOf(attribute);
        }
        return null;
    }

    private void incrementLong(UserWithAttributes userWithAttributes, String key, int defaultValue) {
        Long currentValue = this.getLong(userWithAttributes, key);
        this.setLong((User)userWithAttributes, key, currentValue == null ? (long)defaultValue : currentValue + 1L);
    }

    private long now() {
        return this.clock.getCurrentDate().getTime();
    }
}

