/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.permission.WorkflowPermissionFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.PermissionsCache;
import com.atlassian.jira.security.ProjectPermissionOverrideDescriptorCache;
import com.atlassian.jira.security.WorkflowBasedPermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.atlassian.jira.user.ApplicationUser;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalCachingPermissionManager
extends WorkflowBasedPermissionManager {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalCachingPermissionManager.class);
    private final ProjectFactory projectFactory;

    public ThreadLocalCachingPermissionManager(WorkflowPermissionFactory workflowPermissionFactory, PermissionContextFactory permissionContextFactory, ProjectFactory projectFactory, ProjectPermissionTypesManager projectPermissionTypesManager, ProjectPermissionOverrideDescriptorCache projectPermissionOverrideDescriptorCache) {
        super(workflowPermissionFactory, permissionContextFactory, projectPermissionTypesManager, projectPermissionOverrideDescriptorCache);
        this.projectFactory = projectFactory;
    }

    @Override
    @SuppressWarnings(value={"NM_WRONG_PACKAGE"}, justification="OSUser is deprecated and dying anyway. Plus the method in question is final so we can't override it.")
    public Collection<Project> getProjectObjects(ProjectPermissionKey permissionKey, ApplicationUser user) {
        if (ProjectPermissions.BROWSE_PROJECTS.equals((Object)permissionKey)) {
            PermissionsCache cache = this.getCache();
            Collection<Project> cachedProjects = cache.getProjectObjectsWithBrowsePermission(user);
            if (cachedProjects != null) {
                return cachedProjects;
            }
            cache.setProjectObjectsWithBrowsePermission(user, super.getProjectObjects(permissionKey, user));
            return cache.getProjectObjectsWithBrowsePermission(user);
        }
        return super.getProjectObjects(permissionKey, user);
    }

    private PermissionsCache getCache() {
        PermissionsCache cache = (PermissionsCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new PermissionsCache");
            }
            cache = new PermissionsCache(this.projectFactory);
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.cache", cache);
        }
        return cache;
    }
}

