/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler.cron;

import com.atlassian.fugue.Option;
import com.atlassian.jira.service.util.CronValidationErrorMappingUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.cron.CronSyntaxException;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronValidator {
    private static final Logger LOG = LoggerFactory.getLogger(CronValidator.class);
    private final I18nHelper i18nHelper;
    private final SchedulerService schedulerService;

    public CronValidator(I18nHelper i18nHelper, SchedulerService schedulerService) {
        this.i18nHelper = (I18nHelper)Assertions.notNull((String)"i18nHelper", (Object)i18nHelper);
        this.schedulerService = (SchedulerService)Assertions.notNull((String)"schedulerService", (Object)schedulerService);
    }

    public Option<String> validateCron(String expr) {
        return this.validateCron(expr, null);
    }

    public Option<String> validateCron(String expr, @Nullable TimeZone timeZone) {
        try {
            return this.validateWillRun(expr, timeZone);
        }
        catch (CronSyntaxException cse) {
            LOG.debug("Error parsing cron expression '{}'", (Object)expr, (Object)cse);
            return Option.some((Object)CronValidationErrorMappingUtil.mapError(cse, this.i18nHelper));
        }
        catch (Exception e) {
            LOG.debug("Unexpected error parsing cron expression '{}'", (Object)expr, (Object)e);
            return Option.some((Object)CronValidationErrorMappingUtil.internalError(e.toString(), this.i18nHelper));
        }
    }

    private Option<String> validateWillRun(String expr, TimeZone timeZone) throws SchedulerServiceException {
        if (expr == null) {
            LOG.debug("Asked to validate a null cron expression");
            return Option.some((Object)CronValidationErrorMappingUtil.internalError("null", this.i18nHelper));
        }
        Date date = this.schedulerService.calculateNextRunTime(Schedule.forCronExpression((String)expr, (TimeZone)timeZone));
        if (date == null) {
            return Option.some((Object)this.i18nHelper.getText("cron.expression.invalid.will.never.run", expr));
        }
        return Option.none();
    }
}

