/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.jira.project.template.hook.IssueTypeScreenSchemeTemplate;
import com.atlassian.jira.project.template.hook.ScreenSchemeTemplate;
import com.atlassian.jira.project.template.hook.ScreenSchemeTemplateImpl;
import com.atlassian.jira.project.template.hook.ScreenTemplate;
import com.atlassian.jira.project.template.hook.ScreenTemplateImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class IssueTypeScreenSchemeTemplateImpl
implements IssueTypeScreenSchemeTemplate {
    private final String name;
    private final String description;
    private final String defaultScreenScheme;
    private final List<? extends ScreenTemplate> screenTemplates;
    private final List<? extends ScreenSchemeTemplate> screenSchemeTemplates;

    public IssueTypeScreenSchemeTemplateImpl(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="default-screen-scheme") String defaultScreenScheme, @JsonProperty(value="screens") List<ScreenTemplateImpl> screenTemplates, @JsonProperty(value="screen-schemes") List<ScreenSchemeTemplateImpl> screenSchemeTemplates) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = Strings.nullToEmpty((String)description);
        this.defaultScreenScheme = ((String)Preconditions.checkNotNull((Object)defaultScreenScheme)).toUpperCase();
        this.screenTemplates = (List)Preconditions.checkNotNull(screenTemplates);
        this.screenSchemeTemplates = (List)Preconditions.checkNotNull(screenSchemeTemplates);
        this.validate();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String defaultScreenScheme() {
        return this.defaultScreenScheme;
    }

    public List<ScreenTemplate> screenTemplates() {
        return Collections.unmodifiableList(this.screenTemplates);
    }

    public List<ScreenSchemeTemplate> screenSchemeTemplates() {
        return Collections.unmodifiableList(this.screenSchemeTemplates);
    }

    public boolean hasScreenScheme(String screenSchemeKey) {
        for (ScreenSchemeTemplate screenSchemeTemplate : this.screenSchemeTemplates) {
            if (!screenSchemeTemplate.key().equalsIgnoreCase(screenSchemeKey)) continue;
            return true;
        }
        return false;
    }

    private boolean hasScreen(String screenKey) {
        for (ScreenTemplate screenTemplate : this.screenTemplates) {
            if (!screenTemplate.key().equalsIgnoreCase(screenKey)) continue;
            return true;
        }
        return false;
    }

    private void validate() {
        this.validateDefaultScreenScheme();
        this.validateScreens();
    }

    private void validateDefaultScreenScheme() {
        if (!this.hasScreenScheme(this.defaultScreenScheme)) {
            throw new IllegalArgumentException("Default screen scheme '" + this.defaultScreenScheme + "' of issue type screen scheme '" + this.name + "' does not exist.");
        }
    }

    private void validateScreens() {
        for (ScreenSchemeTemplate screenSchemeTemplate : this.screenSchemeTemplates) {
            if (!this.hasScreen(screenSchemeTemplate.defaultScreen())) {
                throw new IllegalArgumentException("Default screen '" + screenSchemeTemplate.defaultScreen() + "' of screen scheme '" + screenSchemeTemplate.name() + "' does not exist.");
            }
            if (screenSchemeTemplate.createScreen().isPresent() && !this.hasScreen((String)screenSchemeTemplate.createScreen().get())) {
                throw new IllegalArgumentException("Create screen '" + (String)screenSchemeTemplate.createScreen().get() + "' of screen scheme '" + screenSchemeTemplate.name() + "' does not exist.");
            }
            if (screenSchemeTemplate.editScreen().isPresent() && !this.hasScreen((String)screenSchemeTemplate.editScreen().get())) {
                throw new IllegalArgumentException("Edit screen '" + (String)screenSchemeTemplate.editScreen().get() + "' of screen scheme '" + screenSchemeTemplate.name() + "' does not exist.");
            }
            if (!screenSchemeTemplate.viewScreen().isPresent() || this.hasScreen((String)screenSchemeTemplate.viewScreen().get())) continue;
            throw new IllegalArgumentException("View screen '" + (String)screenSchemeTemplate.viewScreen().get() + "' of screen scheme '" + screenSchemeTemplate.name() + "' does not exist.");
        }
    }
}

