/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.descriptor;

import com.atlassian.jira.project.template.descriptor.ConfigTemplateParser;
import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.ConfigTemplateImpl;
import com.atlassian.plugin.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.InjectableValues;
import org.codehaus.jackson.map.ObjectMapper;

public class ConfigTemplateParserImpl
implements ConfigTemplateParser {
    public ConfigTemplate parse(String configFile, Plugin plugin) {
        URL configUrl = plugin.getResource(configFile);
        if (configUrl == null) {
            throw new IllegalArgumentException("No configuration file: " + configFile);
        }
        InputStream inputStream = null;
        try {
            inputStream = configUrl.openStream();
            ConfigTemplate configTemplate = ConfigTemplateParserImpl.parseInput(inputStream, plugin);
            return configTemplate;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while reading configuration file: " + configUrl, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private static ConfigTemplate parseInput(InputStream inputStream, Plugin plugin) {
        ObjectMapper mapper = new ObjectMapper();
        InjectableValues.Std inject = new InjectableValues.Std().addValue("plugin", (Object)plugin);
        try {
            return (ConfigTemplate)mapper.reader(ConfigTemplateImpl.class).withInjectableValues((InjectableValues)inject).readValue(inputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing configuration file.", e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid configuration file.", e);
        }
    }
}

