/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectHistoryLinkFactory
implements WebItemProvider {
    public static final int MAX_RECENT_PROJECTS_TO_SHOW = 5;
    private final UserProjectHistoryManager userHistoryManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public ProjectHistoryLinkFactory(VelocityRequestContextFactory velocityRequestContextFactory, UserProjectHistoryManager userHistoryManager, I18nHelper.BeanFactory beanFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.userHistoryManager = userHistoryManager;
        this.beanFactory = beanFactory;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ArrayList links;
        ProjectAction projectAction = ProjectAction.VIEW_ISSUES;
        ApplicationUser user = (ApplicationUser)context.get("user");
        List history = this.userHistoryManager.getProjectHistoryWithPermissionChecks(projectAction, user);
        ArrayList arrayList = links = history != null ? Lists.newArrayListWithCapacity((int)history.size()) : Lists.newArrayList();
        if (history != null && !history.isEmpty()) {
            VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
            String baseUrl = requestContext.getBaseUrl();
            Project currentProject = this.userHistoryManager.getCurrentProject(10, user);
            I18nHelper i18n = this.beanFactory.getInstance(user);
            int weight = 10;
            for (Project project : history) {
                if (project.equals(currentProject)) continue;
                Long projectId = project.getId();
                String name = project.getName();
                String key = project.getKey();
                String iconUrl = null;
                if (project.getGenericValue().getLong("avatar") != null) {
                    Avatar avatar = project.getAvatar();
                    iconUrl = baseUrl + "/secure/projectavatar?pid=" + projectId + "&avatarId=" + avatar.getId() + "&size=small";
                }
                links.add(new WebFragmentBuilder(weight += 10).id("proj_lnk_" + projectId).label(name + " (" + key + ")").title(i18n.getText("tooltip.browseproject.specified", name)).addParam("iconUrl", iconUrl).webItem("browse_link/project_history_main").url(baseUrl + "/browse/" + key).build());
            }
        }
        return links.subList(0, Math.min(5, links.size()));
    }
}

