/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.project.AbstractProjectManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCache;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@EventComponent
public class CachingProjectManager
extends AbstractProjectManager {
    private final ProjectManager delegateProjectManager;
    private final ProjectComponentManager projectComponentManager;
    private final ProjectFactory projectFactory;
    private final ProjectKeyStore projectKeyStore;
    private final CachedReference<ProjectCache> cache;
    private final NodeAssociationStore nodeAssociationStore;

    public CachingProjectManager(ProjectManager delegateProjectManager, ProjectComponentManager projectComponentManager, ProjectFactory projectFactory, UserManager userManager, ApplicationProperties applicationProperties, ProjectKeyStore projectKeyStore, CacheManager cacheManager, NodeAssociationStore nodeAssociationStore) {
        super(userManager, applicationProperties);
        this.delegateProjectManager = delegateProjectManager;
        this.projectComponentManager = projectComponentManager;
        this.projectFactory = projectFactory;
        this.projectKeyStore = projectKeyStore;
        this.nodeAssociationStore = nodeAssociationStore;
        this.cache = cacheManager.getCachedReference(CachingProjectManager.class.getName() + ".cache", (Supplier)new ProjectCacheSupplier());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.updateCache();
        this.delegateProjectManager.refresh();
    }

    public void updateCache() {
        this.projectKeyStore.refresh();
        this.cache.reset();
    }

    public long getNextId(Project project) {
        return this.delegateProjectManager.getNextId(project);
    }

    public void refresh() {
        this.updateCache();
        this.delegateProjectManager.refresh();
    }

    public Project getProjectObj(Long id) {
        return ((ProjectCache)this.cache.get()).getProject(id);
    }

    public Project getProjectObjByKey(String projectKey) {
        return ((ProjectCache)this.cache.get()).getProjectByKey(projectKey);
    }

    @Override
    public Project getProjectByCurrentKey(String projectKey) {
        return ((ProjectCache)this.cache.get()).getProjectByCurrentKey(projectKey);
    }

    public Project getProjectByCurrentKeyIgnoreCase(String projectKey) {
        return ((ProjectCache)this.cache.get()).getProjectByCurrentKeyIgnoreCase(projectKey);
    }

    public Project getProjectObjByKeyIgnoreCase(String projectKey) {
        return ((ProjectCache)this.cache.get()).getProjectByKeyIgnoreCase(projectKey);
    }

    public Set<String> getAllProjectKeys(Long projectId) {
        return ((ProjectCache)this.cache.get()).getAllProjectKeys(projectId);
    }

    public Project getProjectObjByName(String projectName) {
        return ((ProjectCache)this.cache.get()).getProjectByName(projectName);
    }

    @Nonnull
    public List<Project> getProjects() {
        List<Project> projects = ((ProjectCache)this.cache.get()).getProjectObjects();
        if (projects == null) {
            return Collections.emptyList();
        }
        return projects;
    }

    @Nonnull
    public List<Project> getProjectObjects() {
        return this.getProjects();
    }

    public long getProjectCount() throws DataAccessException {
        return this.getProjectObjects().size();
    }

    protected static <T> Collection<T> noNull(Collection<T> col) {
        if (col == null) {
            return Collections.emptyList();
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createProject(@Nonnull ApplicationUser user, @Nonnull ProjectCreationData projectCreationData) {
        try {
            Project project = this.delegateProjectManager.createProject(user, projectCreationData);
            return project;
        }
        finally {
            this.updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project updateProject(Project updatedProject, String name, String description, String leadKey, String url, Long assigneeType, Long avatarId, String projectKey) {
        try {
            Project project = this.delegateProjectManager.updateProject(updatedProject, name, description, leadKey, url, assigneeType, avatarId, projectKey);
            return project;
        }
        finally {
            this.updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project updateProjectType(ApplicationUser user, Project project, ProjectTypeKey newProjectType) {
        try {
            Project project2 = this.delegateProjectManager.updateProjectType(user, project, newProjectType);
            return project2;
        }
        finally {
            this.updateCache();
        }
    }

    public void removeProjectIssues(Project project) throws RemoveException {
        this.delegateProjectManager.removeProjectIssues(project);
    }

    public void removeProject(Project project) {
        try {
            this.delegateProjectManager.removeProject(project);
        }
        finally {
            this.updateCache();
        }
    }

    public Collection<ProjectCategory> getAllProjectCategories() {
        return CachingProjectManager.noNull(((ProjectCache)this.cache.get()).getProjectCategories());
    }

    public ProjectCategory getProjectCategory(Long id) {
        return this.getProjectCategoryObject(id);
    }

    @Nullable
    public ProjectCategory getProjectCategoryObject(Long id) {
        return ((ProjectCache)this.cache.get()).getProjectCategory(id);
    }

    public void updateProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        try {
            this.delegateProjectManager.updateProjectCategory(projectCategory);
        }
        finally {
            this.updateCache();
        }
    }

    public Collection<Project> getProjectsFromProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        return this.getProjectObjectsFromProjectCategory(projectCategory.getId());
    }

    public Collection<Project> getProjectObjectsFromProjectCategory(Long projectCategoryId) {
        return ((ProjectCache)this.cache.get()).getProjectsFromProjectCategory(projectCategoryId);
    }

    @Nullable
    public ProjectCategory getProjectCategoryForProject(Project project) {
        return ((ProjectCache)this.cache.get()).getProjectCategoryForProject(project);
    }

    public Collection<Project> getProjectObjectsWithNoCategory() throws DataAccessException {
        return ((ProjectCache)this.cache.get()).getProjectsWithNoCategory();
    }

    public void setProjectCategory(Project project, ProjectCategory category) throws DataAccessException {
        try {
            this.delegateProjectManager.setProjectCategory(project, category);
        }
        finally {
            this.updateCache();
        }
    }

    public List<Project> getProjectsLeadBy(ApplicationUser leadUser) {
        return this.delegateProjectManager.getProjectsLeadBy(leadUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectCategory createProjectCategory(String name, String description) {
        try {
            ProjectCategory projectCategory = this.delegateProjectManager.createProjectCategory(name, description);
            return projectCategory;
        }
        finally {
            this.updateCache();
        }
    }

    public void removeProjectCategory(Long id) {
        try {
            this.delegateProjectManager.removeProjectCategory(id);
        }
        finally {
            this.updateCache();
        }
    }

    public long getCurrentCounterForProject(Long id) {
        return this.delegateProjectManager.getCurrentCounterForProject(id);
    }

    public void setCurrentCounterForProject(Project project, long counter) {
        this.delegateProjectManager.setCurrentCounterForProject(project, counter);
    }

    private class ProjectCacheSupplier
    implements Supplier<ProjectCache> {
        private ProjectCacheSupplier() {
        }

        public ProjectCache get() {
            return new ProjectCache(CachingProjectManager.this.delegateProjectManager, CachingProjectManager.this.projectKeyStore, CachingProjectManager.this.nodeAssociationStore);
        }
    }
}

