/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;

public class IsFieldHiddenCondition
extends AbstractWebCondition {
    protected String field;
    protected String issuetype;
    private final FieldVisibilityManager fieldVisibilityManager;

    public IsFieldHiddenCondition(FieldVisibilityManager fieldVisibilityManager) {
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public void init(Map params) throws PluginParseException {
        this.field = (String)params.get("field");
        if (this.field == null) {
            throw new PluginParseException("No 'field' parameter specified for condition: " + ((Object)((Object)this)).getClass().getName());
        }
        this.issuetype = (String)params.get("issuetype");
        if (this.issuetype == null) {
            this.issuetype = "all";
        }
    }

    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        Map params = jiraHelper.getContextParams();
        Issue issue = (Issue)params.get("issue");
        if (issue == null) {
            if (jiraHelper.getProjectObject() != null) {
                return this.fieldVisibilityManager.isFieldHidden(jiraHelper.getProjectObject().getId(), this.field, this.issuetype);
            }
        } else {
            return this.fieldVisibilityManager.isFieldHidden(this.field, issue);
        }
        return false;
    }
}

