/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractPermissionCondition;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.conditions.RequestCachingConditionHelper;
import com.atlassian.jira.plugin.webfragment.conditions.UserIsAdminCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Supplier;
import java.util.Map;

public class CanAdministerProjectCondition
extends AbstractWebCondition {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final UserIsAdminCondition isAdminCondition;

    public CanAdministerProjectCondition(PermissionManager permissionManager, ProjectManager projectManager) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.isAdminCondition = new UserIsAdminCondition(permissionManager);
    }

    public void init(Map<String, String> params) {
    }

    public boolean shouldDisplay(final ApplicationUser user, JiraHelper jiraHelper) {
        final Project project = this.getProject(jiraHelper.getContextParams());
        if (project == null) {
            return false;
        }
        String cacheKey = AbstractPermissionCondition.getHasPermissionKey((ProjectPermissionKey)ProjectPermissions.ADMINISTER_PROJECTS, (ApplicationUser)user, (Object[])new Object[]{project.getKey()});
        return this.isAdminCondition.shouldDisplay(user, jiraHelper) || RequestCachingConditionHelper.cacheConditionResultInRequest((String)cacheKey, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return CanAdministerProjectCondition.this.hasPermission(user, project);
            }
        });
    }

    private boolean hasPermission(ApplicationUser user, Project project) {
        try {
            return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Project getProject(Map<String, Object> context) {
        JiraHelper helper;
        if (context.containsKey("project")) {
            return (Project)context.get("project");
        }
        if (context.containsKey("issue")) {
            return ((Issue)context.get("issue")).getProjectObject();
        }
        if (context.containsKey("helper") && (helper = (JiraHelper)context.get("helper")).getProjectObject() != null) {
            return helper.getProjectObject();
        }
        if (context.containsKey("version")) {
            return ((Version)context.get("version")).getProjectObject();
        }
        if (context.containsKey("component")) {
            Long projectId = ((ProjectComponent)context.get("component")).getProjectId();
            return this.projectManager.getProjectObj(projectId);
        }
        return null;
    }
}

