/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview.auth;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.auth.Authorizer;
import com.atlassian.jira.plugin.searchrequestview.auth.SearchResultSizeAuthorizer;
import com.atlassian.jira.plugin.searchrequestview.auth.UserAuthorizer;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Null;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizerImpl
implements Authorizer {
    private static final Logger log = LoggerFactory.getLogger(AuthorizerImpl.class);
    private final Authorizer delegate;

    public AuthorizerImpl(SearchProvider searchProvider, ApplicationProperties properties, GroupManager groupManager) {
        boolean noLimit;
        Null.not("searchProvider", searchProvider);
        Null.not("properties", properties);
        Null.not("userManager", groupManager);
        long limit = AuthorizerImpl.getResultLimit(properties);
        boolean bl = noLimit = limit < 0L;
        if (noLimit) {
            this.delegate = Authorizer.ALWAYS;
        } else {
            Object authorizer = new SearchResultSizeAuthorizer(searchProvider, limit, Authorizer.ALWAYS);
            String allowedGroupName = properties.getDefaultBackedString("jira.search.views.max.unlimited.group");
            if (StringUtils.isNotBlank((String)allowedGroupName)) {
                Group allowedGroup = groupManager.getGroup(allowedGroupName);
                if (allowedGroup == null) {
                    log.error("The group: '" + allowedGroupName + "' specified as the property: '" + "jira.search.views.max.unlimited.group" + "' does not exist. Cannot setup a group to bypass search result filtering");
                } else {
                    authorizer = new UserAuthorizer(allowedGroup, (Authorizer)authorizer, groupManager);
                }
            }
            this.delegate = authorizer;
        }
    }

    public Authorizer.Result isSearchRequestAuthorized(ApplicationUser user, SearchRequest searchRequest, SearchRequestParams params) {
        return this.delegate.isSearchRequestAuthorized(user, searchRequest, params);
    }

    Authorizer getDelegate() {
        return this.delegate;
    }

    static long getResultLimit(ApplicationProperties properties) {
        String defaultMax = properties.getDefaultBackedString("jira.search.views.max.limit");
        try {
            if (StringUtils.isBlank((String)defaultMax)) {
                return -1L;
            }
            return Long.valueOf(defaultMax).intValue();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot get search result restriction limit for: '" + defaultMax + "' key=" + "jira.search.views.max.limit");
        }
    }
}

