/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculator;
import com.atlassian.jira.plugin.report.impl.AccuracyCalculator;
import com.atlassian.jira.plugin.report.impl.DurationFormatter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

public class ReportIssue {
    private static final Long ZERO = new Long(0L);
    private final Issue issue;
    private final AggregateTimeTrackingBean aggregateBean;
    private final DurationFormatter durationFormatter;
    private final AccuracyCalculator accuracyCalculator;
    private final Collection subTasks;
    private final boolean isOrphan;

    private static List transformSubTasks(Issue issue, final AggregateTimeTrackingCalculator aggregateCalculator, final DurationFormatter durationFormatter, final AccuracyCalculator accuracyCalculator, Comparator comparator, Predicate issueInclusionPredicate) {
        if (issue.getSubTaskObjects() == null || issue.getSubTaskObjects().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList reportIssueSubTasks = Lists.newArrayList((Iterable)issue.getSubTaskObjects());
        CollectionUtils.transform((Collection)reportIssueSubTasks, (Transformer)new Transformer(){

            public Object transform(Object object) {
                Issue issue = (Issue)object;
                return new ReportIssue(issue, aggregateCalculator.getAggregates(issue), durationFormatter, accuracyCalculator, new ArrayList(), false);
            }
        });
        Collections.sort(reportIssueSubTasks, comparator);
        CollectionUtils.filter((Collection)reportIssueSubTasks, (Predicate)issueInclusionPredicate);
        return reportIssueSubTasks;
    }

    private ReportIssue(Issue issue, AggregateTimeTrackingBean aggregateBean, DurationFormatter durationFormatter, AccuracyCalculator accuracyCalculator, List subTasks, boolean isOrphan) {
        this.issue = issue;
        this.aggregateBean = aggregateBean;
        this.durationFormatter = durationFormatter;
        this.accuracyCalculator = accuracyCalculator;
        this.subTasks = Collections.unmodifiableList(subTasks);
        this.isOrphan = isOrphan;
    }

    public ReportIssue(Issue issue, AggregateTimeTrackingCalculator aggregateCalculator, DurationFormatter durationFormatter, AccuracyCalculator accuracyCalculator, Comparator comparator, Predicate issueInclusionPredicate) {
        this(issue, aggregateCalculator.getAggregates(issue), durationFormatter, accuracyCalculator, ReportIssue.transformSubTasks(issue, aggregateCalculator, durationFormatter, accuracyCalculator, comparator, issueInclusionPredicate), true);
    }

    public String getKey() {
        return this.issue.getKey();
    }

    public String getSummary() {
        return this.issue.getSummary();
    }

    public IssueType getIssueType() {
        return this.issue.getIssueTypeObject();
    }

    public Priority getPriority() {
        return this.issue.getPriorityObject();
    }

    public Status getStatus() {
        return this.issue.getStatusObject();
    }

    public String getOriginalEstimate() {
        return this.durationFormatter.shortFormat(this.issue.getOriginalEstimate());
    }

    public String getAggregateOriginalEstimate() {
        if (!this.isOrphan && this.isSubTask()) {
            return "";
        }
        return this.durationFormatter.shortFormat(this.aggregateBean.getOriginalEstimate());
    }

    public String getRemainingEstimate() {
        return this.durationFormatter.shortFormat(this.issue.getEstimate());
    }

    public String getAggregateRemainingEstimate() {
        return !this.isOrphan && this.isSubTask() ? "" : this.durationFormatter.shortFormat(this.aggregateBean.getRemainingEstimate());
    }

    Long getAggregateRemainingEstimateLong(Long defaultValue) {
        return ReportIssue.getNotNull(this.aggregateBean.getRemainingEstimate(), defaultValue);
    }

    Long getAggregateOriginalEstimateLong(Long defaultValue) {
        return ReportIssue.getNotNull(this.aggregateBean.getOriginalEstimate(), defaultValue);
    }

    static Long getNotNull(Long num, Long defaultValue) {
        return num == null ? defaultValue : num;
    }

    public String getTimeSpent() {
        return this.durationFormatter.shortFormat(this.issue.getTimeSpent());
    }

    public String getAggregateTimeSpent() {
        return !this.isOrphan && this.isSubTask() ? "" : this.durationFormatter.shortFormat(this.aggregateBean.getTimeSpent());
    }

    public String getAccuracy() {
        Long accuracy = this.accuracyCalculator.calculateAccuracy(this.issue.getOriginalEstimate(), this.issue.getEstimate(), this.issue.getTimeSpent());
        return this.durationFormatter.format(accuracy);
    }

    public String getAccuracyNice() {
        return this.accuracyCalculator.calculateAndFormatAccuracy(this.issue.getOriginalEstimate(), this.issue.getEstimate(), this.issue.getTimeSpent());
    }

    public String getAccuracyPercentage() {
        return this.getAccuracyPercentage(this.issue.getOriginalEstimate(), this.issue.getEstimate(), this.issue.getTimeSpent());
    }

    public String getAggregateAccuracyPercentage() {
        return this.getAccuracyPercentage(this.aggregateBean.getOriginalEstimate(), this.aggregateBean.getRemainingEstimate(), this.aggregateBean.getTimeSpent());
    }

    private String getAccuracyPercentage(Long originalEstLong, Long timeEstLong, Long timeSpentLong) {
        long originalEst = ReportIssue.getLongNullSafe(originalEstLong);
        if (originalEst == 0L) {
            return "";
        }
        long timeEst = ReportIssue.getLongNullSafe(timeEstLong);
        long timeSpent = ReportIssue.getLongNullSafe(timeSpentLong);
        return "" + AccuracyCalculator.Percentage.calculate(originalEst, timeSpent, timeEst);
    }

    public boolean isTimeTracked() {
        return ReportIssue.isTracked(this.issue.getOriginalEstimate(), this.issue.getEstimate(), this.issue.getTimeSpent());
    }

    public boolean isAggregateTimeTracked() {
        return ReportIssue.isTracked(this.aggregateBean.getOriginalEstimate(), this.aggregateBean.getRemainingEstimate(), this.aggregateBean.getTimeSpent());
    }

    static boolean isTracked(Long original, Long remaining, Long timeSpent) {
        return ReportIssue.getLongNullSafe(original) != 0L || ReportIssue.getLongNullSafe(remaining) != 0L || ReportIssue.getLongNullSafe(timeSpent) != 0L;
    }

    public boolean hasOriginalEstimate() {
        return this.issue.getOriginalEstimate() != null;
    }

    public boolean hasAggregateOriginalEstimate() {
        return this.aggregateBean.getOriginalEstimate() != null;
    }

    public String getAggregateAccuracy() {
        Long accuracy = this.accuracyCalculator.calculateAccuracy(this.aggregateBean.getOriginalEstimate(), this.aggregateBean.getRemainingEstimate(), this.aggregateBean.getTimeSpent());
        return this.durationFormatter.format(accuracy);
    }

    public String getAggregateAccuracyNice() {
        if (!this.isOrphan && this.isSubTask()) {
            return "";
        }
        return this.accuracyCalculator.calculateAndFormatAccuracy(this.aggregateBean.getOriginalEstimate(), this.aggregateBean.getRemainingEstimate(), this.aggregateBean.getTimeSpent());
    }

    public int onSchedule() {
        return this.accuracyCalculator.onSchedule(this.issue.getOriginalEstimate(), this.issue.getEstimate(), this.issue.getTimeSpent());
    }

    public int onScheduleAggregate() {
        return this.accuracyCalculator.onSchedule(this.aggregateBean.getOriginalEstimate(), this.aggregateBean.getRemainingEstimate(), this.aggregateBean.getTimeSpent());
    }

    public Collection getSubTasks() {
        return this.subTasks;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public boolean isOrphan() {
        return this.isOrphan;
    }

    public boolean isSubTask() {
        return this.issue.getParentObject() != null;
    }

    public Issue getParent() {
        return this.issue.getParentObject();
    }

    AggregateTimeTrackingBean getAggregateBean() {
        return this.aggregateBean;
    }

    boolean isAggregateComplete() {
        return this.getAggregateRemainingEstimateLong(ZERO) <= 0L;
    }

    private static long getLongNullSafe(Long value) {
        return value == null ? 0L : value;
    }
}

