/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report;

import com.atlassian.jira.plugin.report.ReportCategory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public class ReportCategoryImpl
implements ReportCategory {
    public static final ReportCategoryImpl AGILE = new ReportCategoryImpl("agile");
    public static final ReportCategoryImpl ISSUE_ANALYSIS = new ReportCategoryImpl("issue.analysis");
    public static final ReportCategoryImpl FORECAST_MANAGEMENT = new ReportCategoryImpl("forecast.management");
    public static final ReportCategoryImpl OTHER = new ReportCategoryImpl("other");
    private static final Map<String, ReportCategoryImpl> BY_KEY;
    private final String key;

    ReportCategoryImpl(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getI18nKey() {
        return "report.category." + this.key;
    }

    @Nullable
    public static ReportCategory byKey(String key) {
        return BY_KEY.get(key);
    }

    static {
        ImmutableList categories = ImmutableList.of((Object)AGILE, (Object)ISSUE_ANALYSIS, (Object)FORECAST_MANAGEMENT, (Object)OTHER);
        BY_KEY = Maps.uniqueIndex((Iterable)categories, (Function)new Function<ReportCategoryImpl, String>(){

            public String apply(ReportCategoryImpl input) {
                return input.getKey();
            }
        });
    }
}

