/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.fugue.Option;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.util.profiling.UtilTimerStack;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssueTabPanelInvokerImpl
implements IssueTabPanelInvoker {
    private static final Logger log = LoggerFactory.getLogger(IssueTabPanelInvokerImpl.class);
    private final I18nHelper.BeanFactory i18Factory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueTabPanelInvokerImpl(I18nHelper.BeanFactory i18Factory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.i18Factory = i18Factory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public boolean invokeShowPanel(final ShowPanelRequest request, final IssueTabPanelModuleDescriptor descriptor) {
        String timerName = "Calling showPanel for " + descriptor;
        UtilTimerStack.push((String)timerName);
        Option showPanel = SafePluginPointAccess.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                IssueTabPanel3 issueTabPanel = (IssueTabPanel3)descriptor.getModule();
                try {
                    return issueTabPanel.showPanel(request);
                }
                catch (AbstractMethodError e) {
                    log.error(IssueTabPanelInvokerImpl.this.formatBinaryCompatibilityMessage(issueTabPanel, "showPanel"), (Throwable)e);
                    return true;
                }
            }
        });
        UtilTimerStack.pop((String)timerName);
        if (showPanel.isEmpty()) {
            log.error("Exception thrown while trying to call showPanel() for " + descriptor);
            return true;
        }
        return (Boolean)showPanel.get();
    }

    @Override
    public List<IssueAction> invokeGetActions(final GetActionsRequest request, final IssueTabPanelModuleDescriptor descriptor) {
        String timerName = "Calling getActions in" + descriptor;
        UtilTimerStack.push((String)timerName);
        Option actions = SafePluginPointAccess.call((Callable)new Callable<List<IssueAction>>(){

            @Override
            public List<IssueAction> call() throws Exception {
                IssueTabPanel3 issueTabPanel = (IssueTabPanel3)descriptor.getModule();
                try {
                    return issueTabPanel.getActions(request);
                }
                catch (AbstractMethodError e) {
                    log.error(IssueTabPanelInvokerImpl.this.formatBinaryCompatibilityMessage(issueTabPanel, "getActions"), (Throwable)e);
                    return Collections.singletonList(new RenderingErrorAction(descriptor));
                }
            }
        });
        UtilTimerStack.pop((String)timerName);
        if (actions.isEmpty()) {
            log.error("Exception thrown while trying to call getActions() for " + descriptor);
        }
        return (List)actions.getOrElse(Collections.singletonList(new RenderingErrorAction(descriptor)));
    }

    private String formatBinaryCompatibilityMessage(IssueTabPanel3 issueTabPanel, String methodName) {
        return String.format("%s does not implement IssueTabPanel.%s(com.atlassian.jira.issues.Issue, com.atlassian.crowd.embedded.api.User). This likely means the plugin is not compatible with this version of JIRA.", methodName, issueTabPanel.getClass().getName());
    }

    class RenderingErrorAction
    implements IssueAction {
        private final IssueTabPanelModuleDescriptor moduleDescriptor;

        public RenderingErrorAction(IssueTabPanelModuleDescriptor moduleDescriptor) {
            this.moduleDescriptor = moduleDescriptor;
        }

        public String getHtml() {
            return IssueTabPanelInvokerImpl.this.i18Factory.getInstance(IssueTabPanelInvokerImpl.this.jiraAuthenticationContext.getUser()).getText("modulewebcomponent.exception", this.moduleDescriptor.getCompleteKey());
        }

        public java.util.Date getTimePerformed() {
            return new Date(System.currentTimeMillis());
        }

        public boolean isDisplayActionAllTab() {
            return true;
        }
    }
}

