/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.attachment;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.attachment.AttachmentProcessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentProcessorModuleDescriptor
extends AbstractJiraModuleDescriptor<AttachmentProcessor> {
    private static final Logger log = LoggerFactory.getLogger(AttachmentProcessorModuleDescriptor.class);
    private ImmutableList<String> fileExtensions;

    public AttachmentProcessorModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        List elements = element.elements();
        if (elements == null) {
            log.error("Invalid descriptor for plugin. No child elements found.");
            this.fileExtensions = ImmutableList.of();
            return;
        }
        ImmutableList.Builder extensionsBuilder = ImmutableList.builder();
        for (Object o : elements) {
            try {
                Element e = (Element)o;
                if (!e.getName().equals("extension")) continue;
                extensionsBuilder.add((Object)e.getStringValue());
            }
            catch (Exception e) {
                log.warn("Error while parsing attachment-processor child element.");
            }
        }
        this.fileExtensions = extensionsBuilder.build();
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(AttachmentProcessor.class);
    }

    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }
}

