/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.attachment;

import com.atlassian.jira.issue.attachment.Path;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntry;
import com.google.common.base.Objects;
import javax.annotation.concurrent.Immutable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;

@JsonAutoDetect
@Immutable
public class AttachmentArchiveEntryImpl
implements AttachmentArchiveEntry {
    private final int entryIndex;
    private final String name;
    private final long size;
    private final String mediaType;

    AttachmentArchiveEntryImpl(int entryIndex, String name, long size, String mediaType) {
        this.entryIndex = entryIndex;
        this.name = name;
        this.size = size;
        this.mediaType = mediaType;
    }

    @Override
    public long getEntryIndex() {
        return this.entryIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getAbbreviatedName() {
        return new Path(this.name).abbreviate(40).toString();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entryIndex, this.name, this.size, this.mediaType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentArchiveEntryImpl other = (AttachmentArchiveEntryImpl)obj;
        return Objects.equal((Object)this.entryIndex, (Object)other.entryIndex) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.size, (Object)other.size) && Objects.equal((Object)this.mediaType, (Object)other.mediaType);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("entryIndex", this.entryIndex).add("name", (Object)this.name).add("size", this.size).add("mediaType", (Object)this.mediaType).toString();
    }
}

