/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginVelocityResourceLoader
extends ResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginVelocityResourceLoader.class);
    private static final Pattern PLUGINKEY_PREFIXED = Pattern.compile("([^:/]+):([^/:]+)/(.*)");

    public void init(ExtendedProperties configuration) {
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        PluginAccessor pluginAccessor = this.pluginAccessor();
        Matcher matcher = PLUGINKEY_PREFIXED.matcher(name);
        if (matcher.matches()) {
            InputStream resourceAsStream;
            String pluginKey = matcher.group(1);
            String resourcePath = StringUtils.stripStart((String)matcher.group(3), (String)"/");
            Plugin plugin = pluginAccessor.getPlugin(pluginKey);
            if (plugin != null && (resourceAsStream = plugin.getResourceAsStream(resourcePath)) != null) {
                return resourceAsStream;
            }
            name = resourcePath;
        }
        String resourceName = StringUtils.stripStart((String)name, (String)"/");
        return pluginAccessor.getDynamicResourceAsStream(resourceName);
    }

    @VisibleForTesting
    PluginAccessor pluginAccessor() {
        return ComponentAccessor.getPluginAccessor();
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }

    public boolean isSourceModified(Resource resource) {
        return true;
    }
}

