/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.plugin.JiraOsgiContainerManager;
import com.atlassian.jira.plugin.OsgiServiceTrackerCache;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiContainerStartedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerStoppedEvent;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiServiceTrackerCacheImpl
implements OsgiServiceTrackerCache,
InitializingComponent {
    private static final Logger log = LoggerFactory.getLogger(OsgiServiceTrackerCacheImpl.class);
    private final OsgiContainerManager osgiContainerManager;
    private final PluginEventManager pluginEventManager;
    @ClusterSafe
    private final LoadingCache<String, CacheObject<ServiceTracker>> serviceTrackerCache;

    public OsgiServiceTrackerCacheImpl(OsgiContainerManager osgiContainerManager, PluginEventManager pluginEventManager) {
        this.osgiContainerManager = osgiContainerManager;
        this.pluginEventManager = pluginEventManager;
        this.serviceTrackerCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).removalListener((RemovalListener)new ServiceTrackerRemovalListener()).build((CacheLoader)new ServiceTrackerLoader());
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    @Override
    public <T> T getOsgiComponentOfType(Class<T> clazz) {
        if (this.osgiContainerManager.isRunning()) {
            ServiceTracker serviceTracker = this.getServiceTrackerFromCache(clazz.getName());
            if (serviceTracker != null) {
                return clazz.cast(serviceTracker.getService());
            }
        } else {
            log.debug("An attempt was made to retrieve an OSGi component of type:{} while the OSGi container was not running.", clazz);
        }
        return null;
    }

    @PluginEventListener
    public void onOsgiContainerStartedEvent(OsgiContainerStartedEvent event) {
        new GoogleCacheInstruments(JiraOsgiContainerManager.class.getSimpleName()).addCache((Cache)this.serviceTrackerCache).install();
    }

    @PluginEventListener
    public void onPluginFrameworkShutdownEvent(OsgiContainerStoppedEvent event) {
        this.serviceTrackerCache.invalidateAll();
    }

    private ServiceTracker getServiceTrackerFromCache(String className) {
        return (ServiceTracker)((CacheObject)this.serviceTrackerCache.getUnchecked((Object)className)).getValue();
    }

    private static class ServiceTrackerRemovalListener
    implements RemovalListener<String, CacheObject<ServiceTracker>> {
        private ServiceTrackerRemovalListener() {
        }

        public void onRemoval(RemovalNotification<String, CacheObject<ServiceTracker>> notification) {
            ServiceTracker serviceTracker;
            CacheObject cacheObject = (CacheObject)notification.getValue();
            if (cacheObject != null && (serviceTracker = (ServiceTracker)cacheObject.getValue()) != null) {
                log.trace("Closing service tracker: {}", (Object)serviceTracker);
                serviceTracker.close();
            }
        }
    }

    private class ServiceTrackerLoader
    extends CacheLoader<String, CacheObject<ServiceTracker>> {
        private ServiceTrackerLoader() {
        }

        public CacheObject<ServiceTracker> load(String className) throws Exception {
            ServiceTracker serviceTracker = OsgiServiceTrackerCacheImpl.this.osgiContainerManager.getServiceTracker(className);
            log.trace("Created service tracker for '{}': {}", (Object)className, (Object)serviceTracker);
            return CacheObject.wrap(serviceTracker);
        }
    }
}

