/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.permission.PermissionAddedEvent;
import com.atlassian.jira.event.permission.PermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeAddedToProjectEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCopiedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCreatedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.permission.PermissionSchemeUpdatedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEntityEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeUtil;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionSchemeManager
extends AbstractSchemeManager
implements PermissionSchemeManager,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DefaultPermissionSchemeManager.class);
    @VisibleForTesting
    static final String SCHEME_ENTITY_NAME = "PermissionScheme";
    private static final String PERMISSION_ENTITY_NAME = "SchemePermissions";
    private static final String SCHEME_DESC = "Permission";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.permissions.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.permissions.default.desc";
    private final Cache<Long, SchemeEntityCacheEntry> schemeEntityCache;
    private final PermissionTypeManager permissionTypeManager;
    private final OfBizDelegator delegator;

    public DefaultPermissionSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, OfBizDelegator delegator, SchemeFactory schemeFactory, NodeAssociationStore nodeAssociationStore, GroupManager groupManager, EventPublisher eventPublisher, CacheManager cacheManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, nodeAssociationStore, delegator, groupManager, eventPublisher, cacheManager);
        this.permissionTypeManager = permissionTypeManager;
        this.delegator = delegator;
        this.schemeEntityCache = cacheManager.getCache(DefaultPermissionSchemeManager.class.getName() + ".schemeEntityCache", (CacheLoader)new SchemeEntityCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void start() throws Exception {
    }

    @Override
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.flushSchemeEntities();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return PERMISSION_ENTITY_NAME;
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    @Override
    protected AbstractSchemeEvent createSchemeCreatedEvent(Scheme scheme) {
        return new PermissionSchemeCreatedEvent(scheme);
    }

    @Override
    @Nonnull
    protected AbstractSchemeCopiedEvent createSchemeCopiedEvent(@Nonnull Scheme oldScheme, @Nonnull Scheme newScheme) {
        return new PermissionSchemeCopiedEvent(oldScheme, newScheme);
    }

    @Override
    protected AbstractSchemeUpdatedEvent createSchemeUpdatedEvent(Scheme scheme, Scheme originalScheme) {
        return new PermissionSchemeUpdatedEvent(scheme, originalScheme);
    }

    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        Scheme scheme = this.getSchemeObject(id);
        super.deleteScheme(id);
        this.eventPublisher.publish((Object)new PermissionSchemeDeletedEvent(id, scheme.getName()));
    }

    @Override
    @Nonnull
    protected AbstractSchemeAddedToProjectEvent createSchemeAddedToProjectEvent(Scheme scheme, Project project) {
        return new PermissionSchemeAddedToProjectEvent(scheme, project);
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId) throws GenericEntityException {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.getEntities(scheme, permissionKey);
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId, String parameter) throws GenericEntityException {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.getEntities(scheme, permissionKey, parameter);
    }

    public List<GenericValue> getEntities(@Nonnull GenericValue scheme, @Nonnull ProjectPermissionKey permissionKey, @Nonnull String parameter) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme, permissionKey), Collections.singletonMap("parameter", parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long permissionId, String type, String parameter) throws GenericEntityException {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.getEntities(scheme, permissionKey, type, parameter);
    }

    public List<GenericValue> getEntities(@Nonnull GenericValue scheme, @Nonnull ProjectPermissionKey permissionKey, @Nonnull String type, @Nonnull String parameter) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme, permissionKey), (Map)MapBuilder.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long permissionId) throws GenericEntityException {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(permissionId);
        return this.getEntitiesByType(scheme, permissionKey, type);
    }

    public List<GenericValue> getEntitiesByType(@Nonnull GenericValue scheme, @Nonnull ProjectPermissionKey permissionKey, @Nonnull String type) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getEntities(scheme, permissionKey), Collections.singletonMap("type", type));
    }

    public List<GenericValue> getEntities(@Nonnull GenericValue scheme, @Nonnull ProjectPermissionKey permissionKey) throws GenericEntityException {
        return this.getEntities(scheme, permissionKey.permissionKey());
    }

    public List<GenericValue> getEntities(GenericValue scheme, String permissionKey) throws GenericEntityException {
        Long key = this.getSchemeEntityCacheKey(scheme);
        List<GenericValue> genericValues = ((SchemeEntityCacheEntry)this.schemeEntityCache.get((Object)key)).getCacheByPermission().get(permissionKey);
        if (genericValues == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(genericValues);
    }

    public Collection<PermissionSchemeEntry> getPermissionSchemeEntries(@Nonnull Scheme scheme, @Nonnull ProjectPermissionKey permissionKey) {
        return this.getPermissionSchemeEntries(scheme.getId(), permissionKey);
    }

    public Collection<PermissionSchemeEntry> getPermissionSchemeEntries(long schemeId, @Nonnull ProjectPermissionKey permissionKey) {
        SchemeEntityCacheEntry schemeEntityCacheEntry = (SchemeEntityCacheEntry)this.schemeEntityCache.get((Object)schemeId);
        if (schemeEntityCacheEntry == null) {
            throw new IllegalArgumentException("Unknown Permission Scheme ID: " + schemeId);
        }
        List<GenericValue> genericValues = schemeEntityCacheEntry.getCacheByPermission().get(permissionKey.permissionKey());
        if (genericValues == null) {
            return Collections.emptyList();
        }
        return Entity.PERMISSION_SCHEME_ENTRY.buildList(genericValues);
    }

    public Collection<PermissionSchemeEntry> getPermissionSchemeEntries(long schemeId, @Nonnull ProjectPermissionKey permissionKey, final @Nonnull String type) {
        Collection<PermissionSchemeEntry> allEntries = this.getPermissionSchemeEntries(schemeId, permissionKey);
        return Lists.newArrayList((Iterable)Iterables.filter(allEntries, (Predicate)new Predicate<PermissionSchemeEntry>(){

            public boolean apply(@Nullable PermissionSchemeEntry permissionSchemeEntry) {
                return type.equals(permissionSchemeEntry.getType());
            }
        }));
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        GenericValue result = this.createSchemeEntityNoEvent(scheme, schemeEntity);
        this.eventPublisher.publish((Object)new PermissionAddedEvent(scheme.getLong("id"), this.withFixedEntityTypeId(schemeEntity)));
        return result;
    }

    private SchemeEntity withFixedEntityTypeId(SchemeEntity original) {
        if (original.getEntityTypeId() instanceof ProjectPermissionKey) {
            return original;
        }
        ProjectPermissionKey permissionKey = (ProjectPermissionKey)PermissionSchemeUtil.getPermissionKey(original).getOrNull();
        return new SchemeEntity(original.getId(), original.getType(), original.getParameter(), (Object)permissionKey, original.getTemplateId(), original.getSchemeId());
    }

    @Override
    protected GenericValue createSchemeEntityNoEvent(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed must NOT be null");
        }
        if (schemeEntity.getType() == null) {
            throw new IllegalArgumentException("Type in SchemeEntity can NOT be null");
        }
        ProjectPermissionKey permissionKey = (ProjectPermissionKey)PermissionSchemeUtil.getPermissionKey(schemeEntity).getOrNull();
        GenericValue perm = EntityUtils.createValue(PERMISSION_ENTITY_NAME, MapBuilder.newBuilder((Object)"scheme", (Object)scheme.getLong("id")).add((Object)"permissionKey", (Object)permissionKey.permissionKey()).add((Object)"type", (Object)schemeEntity.getType()).add((Object)"parameter", (Object)schemeEntity.getParameter()).toMap());
        this.schemeEntityCache.remove((Object)this.getSchemeEntityCacheKey(scheme));
        return perm;
    }

    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        super.deleteEntity(id);
        this.flushSchemeEntities();
    }

    @Override
    public void deleteEntities(Iterable<Long> ids) {
        super.deleteEntities(ids);
        this.flushSchemeEntities();
    }

    protected AbstractSchemeEntityEvent createSchemeEntityDeletedEvent(GenericValue entity) {
        return new PermissionDeletedEvent(entity.getLong("scheme"), this.makeSchemeEntity(entity));
    }

    @Override
    protected SchemeEntity makeSchemeEntity(GenericValue entity) {
        ProjectPermissionKey permissionKey = new ProjectPermissionKey(entity.getString("permissionKey"));
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString("type"), entity.getString("parameter"), (Object)permissionKey);
        schemeEntity.setSchemeId(entity.getLong("scheme"));
        return schemeEntity;
    }

    @Override
    public List<GenericValue> getEntities(GenericValue scheme) throws GenericEntityException {
        Long key = this.getSchemeEntityCacheKey(scheme);
        return Collections.unmodifiableList(((SchemeEntityCacheEntry)this.schemeEntityCache.get((Object)key)).getCache());
    }

    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        boolean result = super.removeEntities(type, parameter);
        this.flushSchemeEntities();
        return result;
    }

    @Override
    public boolean removeEntities(GenericValue scheme, Long permissionId) throws RemoveException {
        if (Permissions.isGlobalPermission((int)permissionId.intValue())) {
            throw new IllegalArgumentException("PermissionId passed must not be a global permissions " + permissionId.toString() + " is global");
        }
        boolean result = super.removeEntities(scheme, permissionId);
        this.schemeEntityCache.remove((Object)this.getSchemeEntityCacheKey(scheme));
        return result;
    }

    public boolean hasSchemePermission(@Nonnull ProjectPermissionKey permissionKey, final @Nonnull Project project) {
        return this.hasSchemePermission(permissionKey, this.getSchemeIdFor(project), new PermissionSchemeEntryChecker(){

            @Override
            public boolean hasPermission(SchemeType schemeType, String parameter) {
                return schemeType.hasPermission(project, parameter);
            }
        });
    }

    public boolean hasSchemePermission(@Nonnull ProjectPermissionKey permissionKey, final @Nonnull Issue issue) {
        return this.hasSchemePermission(permissionKey, this.getSchemeIdFor(issue.getProjectObject()), new PermissionSchemeEntryChecker(){

            @Override
            public boolean hasPermission(SchemeType schemeType, String parameter) {
                return schemeType.hasPermission(issue, parameter);
            }
        });
    }

    public boolean hasSchemePermission(@Nonnull ProjectPermissionKey permissionKey, final @Nonnull Project project, final @Nullable ApplicationUser user, final boolean issueCreation) {
        if (user == null) {
            return this.hasSchemePermission(permissionKey, project);
        }
        return this.hasSchemePermission(permissionKey, this.getSchemeIdFor(project), new PermissionSchemeEntryChecker(){

            @Override
            public boolean hasPermission(SchemeType schemeType, String parameter) {
                return schemeType.hasPermission(project, parameter, user, issueCreation);
            }
        });
    }

    public boolean hasSchemePermission(@Nonnull ProjectPermissionKey permissionKey, final @Nonnull Issue issue, final @Nullable ApplicationUser user, final boolean issueCreation) {
        if (user == null) {
            return this.hasSchemePermission(permissionKey, issue);
        }
        return this.hasSchemePermission(permissionKey, this.getSchemeIdFor(issue.getProjectObject()), new PermissionSchemeEntryChecker(){

            @Override
            public boolean hasPermission(SchemeType schemeType, String parameter) {
                return schemeType.hasPermission(issue, parameter, user, issueCreation);
            }
        });
    }

    @Override
    @Nullable
    public Scheme getSchemeFor(Project project) {
        Scheme scheme = super.getSchemeFor(project);
        if (scheme == null) {
            log.warn("No permission scheme is associated with project '" + project.getName() + "'");
        }
        return scheme;
    }

    @Override
    @Nullable
    public Long getSchemeIdFor(Project project) {
        Long schemeId = super.getSchemeIdFor(project);
        if (schemeId == null) {
            log.warn("No permission scheme is associated with project '" + project.getName() + "'");
        }
        return schemeId;
    }

    @Override
    public Collection<Group> getGroups(Long entityTypeId, Project project) {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(entityTypeId);
        return this.getGroups(permissionKey, project);
    }

    public Collection<Group> getGroups(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project) {
        return this.getGroups(permissionKey, project.getGenericValue());
    }

    @Override
    public Collection<Group> getGroups(Long entityTypeId, GenericValue project) {
        ProjectPermissionKey permissionKey = LegacyProjectPermissionKeyMapping.getKey(entityTypeId);
        return this.getGroups(permissionKey, project);
    }

    private Collection<Group> getGroups(ProjectPermissionKey permissionKey, GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed can NOT be null");
        }
        if (!"Project".equals(project.getEntityName())) {
            throw new IllegalArgumentException("Project passed must be a project not a " + project.getEntityName());
        }
        HashSet<Group> groups = new HashSet<Group>();
        try {
            List<GenericValue> schemes = this.getSchemes(project);
            for (GenericValue scheme : schemes) {
                List<GenericValue> entity = this.getEntitiesByType(scheme, permissionKey, "group");
                for (GenericValue permission : entity) {
                    groups.add(this.groupManager.getGroup(permission.getString("parameter")));
                }
            }
        }
        catch (GenericEntityException e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        return groups;
    }

    public Collection<ApplicationUser> getUsers(@Nonnull ProjectPermissionKey permissionKey, @Nonnull PermissionContext ctx) {
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
        Map permTypes = this.securityTypeManager.getTypes();
        Long schemeId = this.getSchemeIdFor(ctx.getProjectObject());
        Collection<PermissionSchemeEntry> entries = this.getPermissionSchemeEntries(schemeId, permissionKey);
        for (PermissionSchemeEntry entry : entries) {
            SecurityType secType = (SecurityType)permTypes.get(entry.getType());
            if (secType == null) continue;
            try {
                Set<ApplicationUser> usersToAdd = secType.getUsers(ctx, entry.getParameter());
                for (ApplicationUser user : usersToAdd) {
                    if (!user.isActive()) continue;
                    users.add(user);
                }
            }
            catch (IllegalArgumentException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return users;
    }

    @Override
    protected AbstractSchemeRemovedFromProjectEvent createSchemeRemovedFromProjectEvent(Scheme scheme, Project project) {
        return new PermissionSchemeRemovedFromProjectEvent(scheme, project);
    }

    private boolean hasSchemePermission(ProjectPermissionKey permissionKey, Long schemeId, PermissionSchemeEntryChecker permissionSchemeEntryChecker) {
        if (schemeId == null) {
            return false;
        }
        Map securityTypes = this.permissionTypeManager.getTypes();
        Collection<PermissionSchemeEntry> entities = this.getPermissionSchemeEntries(schemeId, permissionKey);
        for (PermissionSchemeEntry schemeEntry : entities) {
            SecurityType securityType;
            if (schemeEntry == null || (securityType = (SecurityType)securityTypes.get(schemeEntry.getType())) == null || !securityType.isValidForPermission(permissionKey) || !permissionSchemeEntryChecker.hasPermission(securityType, schemeEntry.getParameter())) continue;
            return true;
        }
        return false;
    }

    private Long getSchemeEntityCacheKey(GenericValue scheme) {
        return scheme.getLong("id");
    }

    public void flushSchemeEntities() {
        this.schemeEntityCache.removeAll();
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        List entities = this.delegator.findByAnd(PERMISSION_ENTITY_NAME, (Map)FieldMap.build((String)"type", (Object)type, (String)"parameter", (Object)parameter));
        HashSet<Long> schemeIds = new HashSet<Long>();
        ArrayList entityConditions = Lists.newArrayListWithCapacity((int)entities.size());
        for (GenericValue schemeEntity : entities) {
            schemeIds.add(schemeEntity.getLong("scheme"));
        }
        for (Long id : schemeIds) {
            entityConditions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)id));
        }
        List schemes = !entityConditions.isEmpty() ? this.delegator.findByOr(SCHEME_ENTITY_NAME, (List)entityConditions, Collections.emptyList()) : Collections.emptyList();
        return schemes;
    }

    private static interface PermissionSchemeEntryChecker {
        public boolean hasPermission(SchemeType var1, String var2);
    }

    private class SchemeEntityCacheLoader
    implements CacheLoader<Long, SchemeEntityCacheEntry> {
        private SchemeEntityCacheLoader() {
        }

        public SchemeEntityCacheEntry load(Long key) {
            SchemeEntityCacheEntry cacheEntry = new SchemeEntityCacheEntry();
            cacheEntry.load(key);
            return cacheEntry;
        }
    }

    private class SchemeEntityCacheEntry {
        private List<GenericValue> cache = null;
        private final Map<String, List<GenericValue>> cacheByPermission = Maps.newHashMap();

        private SchemeEntityCacheEntry() {
        }

        public List<GenericValue> getCache() {
            return this.cache;
        }

        public Map<String, List<GenericValue>> getCacheByPermission() {
            return this.cacheByPermission;
        }

        public void load(Long key) {
            List schemeEntities;
            try {
                GenericValue scheme = DefaultPermissionSchemeManager.super.getScheme(key);
                schemeEntities = DefaultPermissionSchemeManager.super.getEntities(scheme);
            }
            catch (GenericEntityException e) {
                throw new RuntimeException(e);
            }
            this.cache = schemeEntities;
            for (GenericValue entity : schemeEntities) {
                String permissionKey = entity.getString("permissionKey");
                List<GenericValue> entitiesForPermission = this.cacheByPermission.get(permissionKey);
                if (entitiesForPermission == null) {
                    entitiesForPermission = new ArrayList<GenericValue>();
                    this.cacheByPermission.put(permissionKey, entitiesForPermission);
                }
                entitiesForPermission.add(entity);
            }
        }
    }
}

