/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.jdbc.interceptors.SQLInterceptor;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;

public class ChainedSQLInterceptor
implements SQLConnectionInterceptor {
    private final List<SQLConnectionInterceptor> interceptorsList;
    private final List<SQLConnectionInterceptor> reverseInterceptorsList;

    public ChainedSQLInterceptor(List<SQLConnectionInterceptor> interceptorsList) {
        this.interceptorsList = new ArrayList<SQLConnectionInterceptor>(interceptorsList);
        this.reverseInterceptorsList = new ArrayList<SQLConnectionInterceptor>(interceptorsList);
        Collections.reverse(this.reverseInterceptorsList);
    }

    public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
        for (SQLConnectionInterceptor sqlInterceptor : this.interceptorsList) {
            sqlInterceptor.onConnectionTaken(connection, connectionPoolState);
        }
    }

    public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
        for (SQLConnectionInterceptor sqlInterceptor : this.reverseInterceptorsList) {
            sqlInterceptor.onConnectionReplaced(connection, connectionPoolState);
        }
    }

    public void beforeExecution(String sqlString, List<String> parameterValues, Statement statement) {
        for (SQLInterceptor sQLInterceptor : this.interceptorsList) {
            sQLInterceptor.beforeExecution(sqlString, parameterValues, statement);
        }
    }

    public void afterSuccessfulExecution(String sqlString, List<String> parameterValues, Statement statement, ResultSet resultSet, int rowsUpdated) {
        for (SQLInterceptor sQLInterceptor : this.reverseInterceptorsList) {
            sQLInterceptor.afterSuccessfulExecution(sqlString, parameterValues, statement, resultSet, rowsUpdated);
        }
    }

    public void onException(String sqlString, List<String> parameterValues, Statement statement, SQLException sqlException) {
        for (SQLInterceptor sQLInterceptor : this.reverseInterceptorsList) {
            sQLInterceptor.onException(sqlString, parameterValues, statement, sqlException);
        }
    }

    public static class Builder {
        private List<SQLConnectionInterceptor> interceptorsList = new ArrayList<SQLConnectionInterceptor>();

        public Builder add(SQLConnectionInterceptor sqlInterceptor) {
            this.interceptorsList.add(sqlInterceptor);
            return this;
        }

        public ChainedSQLInterceptor build() {
            return new ChainedSQLInterceptor(this.interceptorsList);
        }
    }
}

