/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.EventUtils;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentAssignee
extends AbstractNotificationType {
    private static final Logger log = LoggerFactory.getLogger(CurrentAssignee.class);
    private JiraAuthenticationContext jiraAuthenticationContext;

    public CurrentAssignee(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        List<Object> recipients;
        Issue issue = event.getIssue();
        if (issue != null) {
            recipients = this.getRecipientsForIssue(event, issue);
        } else {
            log.error("Error getting assignee notification recipients - no issue associated with event: " + event.getEventTypeId());
            recipients = Collections.emptyList();
        }
        return recipients;
    }

    List<NotificationRecipient> getRecipientsForIssue(IssueEvent event, Issue issue) {
        ArrayList recipients = Lists.newArrayListWithCapacity((int)2);
        this.addPreviousAssignee(event, recipients);
        this.addCurrentAssignee(issue, recipients);
        return recipients;
    }

    private void addCurrentAssignee(Issue issue, List<NotificationRecipient> recipients) {
        UserManager userManager = ComponentAccessor.getUserManager();
        ApplicationUser u = userManager.getUserByKey(issue.getAssigneeId());
        if (u != null) {
            recipients.add(new NotificationRecipient(u));
        }
    }

    private void addPreviousAssignee(IssueEvent event, List<NotificationRecipient> recipients) {
        ApplicationUser previousAssignee = this.getPreviousAssignee(event);
        if (previousAssignee != null) {
            recipients.add(new NotificationRecipient(previousAssignee));
        }
    }

    protected ApplicationUser getPreviousAssignee(IssueEvent event) {
        return EventUtils.getPreviousAssignee(event);
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.current.assignee");
    }
}

