/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.NotificationJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.PermissionJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.mail.MailService;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.notification.NotificationBuilderImpl;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class AdhocNotificationServiceImpl
implements AdhocNotificationService {
    private final MailService mailService;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final WatcherService watcherService;
    private final VoteService voteService;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final NotificationSchemeManager notificationSchemeManager;
    private final NotificationFilterManager notificationFilterManager;
    private final UserPreferencesManager userPreferencesManager;

    public AdhocNotificationServiceImpl(MailService mailService, UserManager userManager, GroupManager groupManager, WatcherService watcherService, VoteService voteService, PermissionManager permissionManager, I18nHelper.BeanFactory i18nBeanFactory, NotificationSchemeManager notificationSchemeManager, NotificationFilterManager notificationFilterManager, UserPreferencesManager userPreferencesManager) {
        this.notificationFilterManager = notificationFilterManager;
        this.mailService = (MailService)Assertions.notNull((String)"mailService", (Object)mailService);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.groupManager = (GroupManager)Assertions.notNull((String)"groupManager", (Object)groupManager);
        this.watcherService = (WatcherService)Assertions.notNull((String)"watcherService", (Object)watcherService);
        this.voteService = (VoteService)Assertions.notNull((String)"voteService", (Object)voteService);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.i18nBeanFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nBeanFactory", (Object)i18nBeanFactory);
        this.notificationSchemeManager = (NotificationSchemeManager)Assertions.notNull((String)"notificationSchemeManager", (Object)notificationSchemeManager);
        this.userPreferencesManager = (UserPreferencesManager)Assertions.notNull((String)"userPreferencesManager", (Object)userPreferencesManager);
    }

    public NotificationBuilder makeBuilder() {
        return new NotificationBuilderImpl();
    }

    public static ServiceOutcome<NotificationBuilder> makeBuilder(NotificationBuilder notificationBuilder, NotificationJsonBean jsonBean, I18nHelper i18nHelper) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        List<Permissions.Permission> permissions = AdhocNotificationServiceImpl.toPermissions(jsonBean.getRestrict().getPermissions(), (ErrorCollection)errors, i18nHelper);
        return ServiceOutcomeImpl.from((ErrorCollection)errors, notificationBuilder.setTemplate("issuenotify.vm").setTemplateParams(ImmutableMap.of((Object)"subject", (Object)StringUtils.defaultString((String)jsonBean.getSubject()), (Object)"textBody", (Object)StringUtils.defaultString((String)jsonBean.getTextBody()), (Object)"htmlBody", (Object)StringUtils.defaultString((String)jsonBean.getHtmlBody()))).setToReporter(jsonBean.getTo().isReporter()).setToAssignee(jsonBean.getTo().isAssignee()).setToWatchers(jsonBean.getTo().isWatchers()).setToVoters(jsonBean.getTo().isVoters()).addToGroups(AdhocNotificationServiceImpl.toGroupNames(jsonBean.getTo().getGroups())).addToUsers(AdhocNotificationServiceImpl.toUsernames(jsonBean.getTo().getUsers())).addRestrictGroups(AdhocNotificationServiceImpl.toGroupNames(jsonBean.getRestrict().getGroups())).addRestrictPermissions(permissions));
    }

    private static List<String> toUsernames(List<UserJsonBean> users) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(users, (Function)new Function<UserJsonBean, String>(){

            public String apply(UserJsonBean input) {
                return input.getName();
            }
        }));
    }

    private static List<String> toGroupNames(List<GroupJsonBean> groups) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(groups, (Function)new Function<GroupJsonBean, String>(){

            public String apply(GroupJsonBean input) {
                return input.getName();
            }
        }));
    }

    private static List<Permissions.Permission> toPermissions(List<PermissionJsonBean> permissionBeans, ErrorCollection errors, I18nHelper i18nHelper) {
        ArrayList permissions = Lists.newArrayList();
        for (PermissionJsonBean permissionBean : permissionBeans) {
            Permissions.Permission p = permissionBean.asPermission();
            if (p != null) {
                permissions.add(p);
                continue;
            }
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.unknown.permission", (Object)permissionBean));
        }
        return permissions;
    }

    public AdhocNotificationService.ValidateNotificationResult validateNotification(NotificationBuilder notification, ApplicationUser user, Issue issue) {
        return this.validateNotification(notification, user, issue, AdhocNotificationService.ValiationOption.FAIL_ON_NO_RECIPIENTS);
    }

    public AdhocNotificationService.ValidateNotificationResult validateNotification(final NotificationBuilder notification, final ApplicationUser user, final Issue issue, AdhocNotificationService.ValiationOption option) {
        Supplier recipients = Suppliers.memoize((Supplier)new Supplier<Iterable<NotificationRecipient>>(){

            public Iterable<NotificationRecipient> get() {
                return AdhocNotificationServiceImpl.this.getRecipients(user, issue, notification);
            }
        });
        ErrorCollection errors = this.validate((Supplier<Iterable<NotificationRecipient>>)recipients, notification, user, issue, option);
        return new AdhocNotificationService.ValidateNotificationResult(errors, notification, recipients, user, issue);
    }

    private ErrorCollection validate(Supplier<Iterable<NotificationRecipient>> recipients, NotificationBuilder notification, ApplicationUser remoteUser, Issue issue, AdhocNotificationService.ValiationOption option) {
        Iterable unknwonGroups;
        Iterable unknownUsers;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(remoteUser);
        if (!this.permissionManager.hasPermission(10, issue, remoteUser)) {
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.no.browse.permission", issue.getKey()));
        }
        if (!Iterables.isEmpty((Iterable)(unknownUsers = Iterables.filter((Iterable)notification.getToUsers(), (Predicate)new UnknownUserPredicate(this.userManager))))) {
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.unknown.users", (Object)unknownUsers));
        }
        if (!Iterables.isEmpty((Iterable)(unknwonGroups = Iterables.filter((Iterable)Iterables.concat((Iterable)notification.getToGroups(), (Iterable)notification.getRestrictGroups()), (Predicate)new UnknownGroupPredicate(this.groupManager))))) {
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.unknown.groups", (Object)unknwonGroups));
        }
        if (AdhocNotificationService.ValiationOption.FAIL_ON_NO_RECIPIENTS.equals((Object)option) && !errors.hasAnyErrors() && Iterables.isEmpty((Iterable)((Iterable)recipients.get()))) {
            errors.addErrorMessage(i18nHelper.getText("adhoc.notification.error.no.recipients"));
        }
        return errors;
    }

    public void sendNotification(AdhocNotificationService.ValidateNotificationResult result) {
        if (!result.isValid()) {
            throw new IllegalStateException("Validation result was not valid.");
        }
        this.sendNotification(result.from, (Iterable)result.recipients.get(), (Map<String, Object>)AdhocNotificationServiceImpl.getParams(result.from, result.issue, result.notification), result.notification.getTemplate());
    }

    private void sendNotification(ApplicationUser from, Iterable<NotificationRecipient> recipients, Map<String, Object> params, String template) {
        NotificationFilterContext context = this.notificationFilterManager.makeContextFrom((NotificationReason)JiraNotificationReason.ADHOC_NOTIFICATION);
        for (NotificationRecipient recipient : recipients) {
            if (this.notificationFilterManager.filtered(recipient, context)) continue;
            String bodyTemplatePath = "templates/email/" + recipient.getFormat() + '/' + template;
            this.mailService.sendRenderedMail(from, recipient, "templates/email/subject/" + template, bodyTemplatePath, params);
        }
    }

    private Iterable<NotificationRecipient> getRecipients(ApplicationUser remoteUser, Issue issue, NotificationBuilder notification) {
        if (this.noRecipientsDefined(notification)) {
            return this.getRecipientsFromNotificationScheme(remoteUser, issue);
        }
        return this.getRecipientsFromNotification(remoteUser, issue, notification);
    }

    private boolean noRecipientsDefined(NotificationBuilder notification) {
        return !notification.isToReporter() && !notification.isToAssignee() && !notification.isToVoters() && !notification.isToWatchers() && notification.getToEmails().isEmpty() && notification.getToUsers().isEmpty() && notification.getToGroups().isEmpty();
    }

    private Iterable<NotificationRecipient> getRecipientsFromNotificationScheme(ApplicationUser remoteUser, Issue issue) {
        return this.notificationSchemeManager.getRecipients(new IssueEvent(issue, (Map)ImmutableMap.of(), remoteUser, EventType.ISSUE_GENERICEVENT_ID));
    }

    private Iterable<NotificationRecipient> getRecipientsFromNotification(ApplicationUser remoteUser, Issue issue, NotificationBuilder notification) {
        ImmutableList.Builder recipients = ImmutableList.builder().addAll(AdhocNotificationServiceImpl.getEmailRecipients(notification)).addAll(this.getUserRecipients(notification)).addAll(this.getGroupRecipients(notification));
        if (notification.isToReporter()) {
            recipients.add((Object)new NotificationRecipient(issue.getReporter()));
        }
        if (notification.isToAssignee()) {
            recipients.add((Object)new NotificationRecipient(issue.getAssignee()));
        }
        if (notification.isToWatchers()) {
            recipients.addAll(this.getWatchersRecipients(remoteUser, issue));
        }
        if (notification.isToVoters()) {
            recipients.addAll(this.getVotersRecipients(remoteUser, issue));
        }
        return this.restrict(this.removeRemoteUserIfNecessary((Iterable<NotificationRecipient>)recipients.build(), remoteUser), issue, (NotificationBuilderImpl)notification);
    }

    private Iterable<NotificationRecipient> removeRemoteUserIfNecessary(Iterable<NotificationRecipient> recipients, ApplicationUser user) {
        ApplicationUser appUser = user;
        if (appUser == null || this.userPreferencesManager.getExtendedPreferences(appUser).getBoolean("user.notify.own.changes")) {
            return recipients;
        }
        return this.removeRemoteUser(recipients, appUser);
    }

    private Iterable<NotificationRecipient> removeRemoteUser(Iterable<NotificationRecipient> recipients, ApplicationUser user) {
        final NotificationRecipient userRecipient = new NotificationRecipient(user);
        return Iterables.filter(recipients, (Predicate)new Predicate<NotificationRecipient>(){

            public boolean apply(NotificationRecipient recipient) {
                return !recipient.equals((Object)userRecipient);
            }
        });
    }

    private Iterable<NotificationRecipient> restrict(Iterable<NotificationRecipient> recipients, Issue issue, NotificationBuilderImpl notification) {
        ArrayList permissions;
        Iterable restricted = recipients;
        ArrayList groups = Lists.newArrayList(notification.getRestrictGroups());
        if (!groups.isEmpty()) {
            restricted = Iterables.filter(restricted, (Predicate)new NotificationRecipientInAnyGroupPredicate(groups, this.groupManager));
        }
        if (!(permissions = Lists.newArrayList(notification.getRestrictPermissions())).isEmpty()) {
            restricted = Iterables.filter((Iterable)restricted, (Predicate)new NotificationRecipientHasAnyPermissionPredicate(permissions, issue, this.permissionManager));
        }
        return restricted;
    }

    @VisibleForTesting
    Iterable<NotificationRecipient> getVotersRecipients(ApplicationUser remoteUser, Issue issue) {
        Collection voters = (Collection)this.voteService.viewVoters(issue, remoteUser).getReturnedValue();
        if (voters == null) {
            return ImmutableList.of();
        }
        return Iterables.transform((Iterable)voters, (Function)new UserToNotificationRecipientFunction());
    }

    private Iterable<NotificationRecipient> getWatchersRecipients(ApplicationUser remoteUser, Issue issue) {
        return Iterables.transform((Iterable)((Iterable)((Pair)this.watcherService.getWatchers(issue, remoteUser).getReturnedValue()).second()), (Function)new UserToNotificationRecipientFunction());
    }

    private Iterable<NotificationRecipient> getGroupRecipients(NotificationBuilder notification) {
        return Iterables.concat((Iterable)Iterables.transform((Iterable)notification.getToGroups(), (Function)new GroupNameToNotificationRecipientIterableFunction(this.groupManager)));
    }

    private Iterable<NotificationRecipient> getUserRecipients(NotificationBuilder notificationBean) {
        return Iterables.transform((Iterable)Iterables.transform((Iterable)notificationBean.getToUsers(), (Function)new UserNameToUserFunction(this.userManager)), (Function)new UserToNotificationRecipientFunction());
    }

    private static Iterable<NotificationRecipient> getEmailRecipients(NotificationBuilder notificationBuilder) {
        return Iterables.transform((Iterable)notificationBuilder.getToEmails(), (Function)new EmailToNotificationRecipientFunction());
    }

    private static ImmutableMap<String, Object> getParams(ApplicationUser from, Issue issue, NotificationBuilder notification) {
        return ImmutableMap.builder().put((Object)"issue", (Object)issue).put((Object)"remoteUser", (Object)from).putAll((Map)notification.getTemplateParams()).build();
    }

    private static class UnknownGroupPredicate
    implements Predicate<String> {
        private final GroupManager groupManager;

        public UnknownGroupPredicate(GroupManager groupManager) {
            this.groupManager = (GroupManager)Assertions.notNull((Object)groupManager);
        }

        public boolean apply(String userName) {
            return !this.groupManager.groupExists(userName);
        }
    }

    private static class UnknownUserPredicate
    implements Predicate<String> {
        private final UserManager userManager;

        public UnknownUserPredicate(UserManager userManager) {
            this.userManager = (UserManager)Assertions.notNull((Object)userManager);
        }

        public boolean apply(String userName) {
            return this.userManager.getUser(userName) == null;
        }
    }

    private static class NotificationRecipientHasAnyPermissionPredicate
    implements Predicate<NotificationRecipient> {
        private final List<Integer> permissions;
        private final Issue issue;
        private final PermissionManager permissionManager;

        public NotificationRecipientHasAnyPermissionPredicate(List<Integer> permissions, Issue issue, PermissionManager permissionManager) {
            this.permissions = (List)Assertions.notNull(permissions);
            this.issue = (Issue)Assertions.notNull((Object)issue);
            this.permissionManager = (PermissionManager)Assertions.notNull((Object)permissionManager);
        }

        public boolean apply(NotificationRecipient recipient) {
            ApplicationUser recipientUser = recipient.getUser();
            return recipientUser != null && Iterables.any(this.permissions, (Predicate)new HasIssuePermissionPredicate(this.issue, recipientUser, this.permissionManager));
        }
    }

    private static final class HasIssuePermissionPredicate
    implements Predicate<Integer> {
        private final Issue issue;
        private final ApplicationUser user;
        private final PermissionManager permissionManager;

        public HasIssuePermissionPredicate(Issue issue, ApplicationUser user, PermissionManager permissionManager) {
            this.issue = (Issue)Assertions.notNull((Object)issue);
            this.user = (ApplicationUser)Assertions.notNull((Object)user);
            this.permissionManager = (PermissionManager)Assertions.notNull((Object)permissionManager);
        }

        public boolean apply(Integer permission) {
            return this.permissionManager.hasPermission(permission.intValue(), this.issue, this.user);
        }
    }

    private static final class NotificationRecipientInAnyGroupPredicate
    implements Predicate<NotificationRecipient> {
        private final GroupManager groupManager;
        private final List<String> groups;

        public NotificationRecipientInAnyGroupPredicate(List<String> groups, GroupManager groupManager) {
            this.groups = (List)Assertions.notNull(groups);
            this.groupManager = (GroupManager)Assertions.notNull((Object)groupManager);
        }

        public boolean apply(NotificationRecipient recipient) {
            ApplicationUser recipientUser = recipient.getUserRecipient();
            return recipientUser != null && Iterables.any(this.groups, (Predicate)new UserInGroupPredicate(recipientUser, this.groupManager));
        }
    }

    private static class UserInGroupPredicate
    implements Predicate<String> {
        private final ApplicationUser user;
        private final GroupManager groupManager;

        public UserInGroupPredicate(ApplicationUser user, GroupManager groupManager) {
            this.user = (ApplicationUser)Assertions.notNull((Object)user);
            this.groupManager = (GroupManager)Assertions.notNull((Object)groupManager);
        }

        public boolean apply(String groupName) {
            return this.groupManager.isUserInGroup(this.user.getName(), groupName);
        }
    }

    private static class UserNameToUserFunction
    implements Function<String, ApplicationUser> {
        private final UserManager userManager;

        private UserNameToUserFunction(UserManager userManager) {
            this.userManager = (UserManager)Assertions.notNull((Object)userManager);
        }

        public ApplicationUser apply(String userName) {
            return this.userManager.getUser(userName);
        }
    }

    private static final class GroupNameToNotificationRecipientIterableFunction
    implements Function<String, Iterable<NotificationRecipient>> {
        private final GroupManager groupManager;

        private GroupNameToNotificationRecipientIterableFunction(GroupManager groupManager) {
            this.groupManager = (GroupManager)Assertions.notNull((Object)groupManager);
        }

        public Iterable<NotificationRecipient> apply(String group) {
            return Iterables.transform((Iterable)this.groupManager.getUsersInGroup(group), (Function)new UserToNotificationRecipientFunction());
        }
    }

    private static final class UserToNotificationRecipientFunction
    implements Function<ApplicationUser, NotificationRecipient> {
        private UserToNotificationRecipientFunction() {
        }

        public NotificationRecipient apply(ApplicationUser user) {
            return new NotificationRecipient(user);
        }
    }

    private static final class EmailToNotificationRecipientFunction
    implements Function<String, NotificationRecipient> {
        private EmailToNotificationRecipientFunction() {
        }

        public NotificationRecipient apply(String email) {
            return new NotificationRecipient(email);
        }
    }
}

