/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.memoryinspector;

import com.atlassian.jira.memoryinspector.ThreadInfo;
import com.google.common.base.Predicate;
import java.util.regex.Pattern;

public class ThreadInfoPredicate
implements Predicate<ThreadInfo> {
    private static final Pattern ANY = Pattern.compile(".*");
    private final Pattern threadNamePattern;
    private final Pattern threadClassNamePattern;
    private final Pattern threadGroupPattern;

    public static Predicate<ThreadInfo> matchClass(final String threadClassNamePattern) {
        return new Predicate<ThreadInfo>(){

            public boolean apply(ThreadInfo threadInfo) {
                return Pattern.compile(threadClassNamePattern).matcher(threadInfo.getThreadClassName()).matches();
            }
        };
    }

    public static Predicate<ThreadInfo> matchName(final String threadNamePattern) {
        return new Predicate<ThreadInfo>(){

            public boolean apply(ThreadInfo threadInfo) {
                return Pattern.compile(threadNamePattern).matcher(threadInfo.getThreadName()).matches();
            }
        };
    }

    public static Predicate<ThreadInfo> matchGroup(final String threadGroupPattern) {
        return new Predicate<ThreadInfo>(){

            public boolean apply(ThreadInfo threadInfo) {
                return Pattern.compile(threadGroupPattern).matcher(threadInfo.getThreadGroupName()).matches();
            }
        };
    }

    public static Predicate<ThreadInfo> matchClassLoaderClassName(final String pattern) {
        return new Predicate<ThreadInfo>(){

            public boolean apply(ThreadInfo threadInfo) {
                return Pattern.compile(pattern).matcher(threadInfo.getClassLoaderClassName()).matches();
            }
        };
    }

    public static Predicate<ThreadInfo> matchClassAndName(String threadClassNamePattern, String threadNamePattern) {
        return new ThreadInfoPredicate(Pattern.compile(threadClassNamePattern), Pattern.compile(threadNamePattern), ANY);
    }

    public static Predicate<ThreadInfo> matchNameAndGroup(String threadNamePattern, String threadGroupPattern) {
        return new ThreadInfoPredicate(ANY, Pattern.compile(threadNamePattern), Pattern.compile(threadGroupPattern));
    }

    public static Predicate<ThreadInfo> matchClassAndNameAndGroup(String threadClassNamePattern, String threadNamePattern, String threadGroupPattern) {
        return new ThreadInfoPredicate(Pattern.compile(threadClassNamePattern), Pattern.compile(threadNamePattern), Pattern.compile(threadGroupPattern));
    }

    public static Predicate<ThreadInfo> matchState(final Thread.State state) {
        return new Predicate<ThreadInfo>(){

            public boolean apply(ThreadInfo threadInfo) {
                return state.equals((Object)threadInfo.getThread().getState());
            }
        };
    }

    public ThreadInfoPredicate(Pattern threadClassNamePattern, Pattern threadNamePattern, Pattern threadGroupPattern) {
        this.threadNamePattern = threadNamePattern;
        this.threadClassNamePattern = threadClassNamePattern;
        this.threadGroupPattern = threadGroupPattern;
    }

    public boolean apply(ThreadInfo threadInfo) {
        return this.threadNamePattern.matcher(threadInfo.getThreadName()).matches() && this.threadClassNamePattern.matcher(threadInfo.getThreadClassName()).matches() && this.threadGroupPattern.matcher(threadInfo.getThreadGroupName()).matches();
    }
}

