/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.builder;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.mail.CssInliner;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.mail.util.MailAttachmentsManagerImpl;
import com.atlassian.jira.template.TemplateSource;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmailRenderer {
    private static final Logger log = LoggerFactory.getLogger(EmailRenderer.class);
    private final Email email;
    private final TemplateSource subjectTemplate;
    private final TemplateSource bodyTemplate;
    private final Set<BodyPart> attachments;
    private final Map<String, Object> templateParameters;

    public EmailRenderer(Email email, TemplateSource subjectTemplate, TemplateSource bodyTemplate, Set<BodyPart> attachments, Map<String, Object> templateParameters) {
        this.email = email;
        this.subjectTemplate = subjectTemplate;
        this.bodyTemplate = bodyTemplate;
        this.attachments = attachments;
        this.templateParameters = templateParameters;
    }

    public Email getEmail() {
        return this.email;
    }

    public String getSubject() {
        I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        Map<String, Object> contextParams = JiraMailQueueUtils.getContextParamsBody(this.templateParameters);
        contextParams.put("i18n", i18n);
        try {
            return this.renderEmailSubject(contextParams);
        }
        catch (VelocityException e) {
            log.error("Could not determine e-mail subject", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String renderEmailSubject(Map<String, Object> contextParams) {
        return this.getTemplatingEngine().render(this.subjectTemplate).applying(contextParams).asPlainText();
    }

    private VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }

    private void renderEmailBody(Map<String, Object> contextParams) throws MessagingException {
        String renderedMailBody;
        MailAttachmentsManager attachmentsManager = this.createAttachmentsManager();
        contextParams.put("attachmentsManager", attachmentsManager);
        if (this.email.getMimeType().equals("text/html")) {
            CssInliner cssInliner = (CssInliner)ComponentAccessor.getComponent(CssInliner.class);
            renderedMailBody = this.getTemplatingEngine().render(this.bodyTemplate).applying(contextParams).asPlainText();
            renderedMailBody = cssInliner.applyStyles(renderedMailBody);
        } else {
            renderedMailBody = this.getTemplatingEngine().render(this.bodyTemplate).applying(contextParams).asPlainText();
        }
        if (attachmentsManager.getAttachmentsCount() > 0) {
            String contentType = String.format("%s; charset=%s", this.email.getMimeType(), this.email.getEncoding());
            Multipart multiPart = this.buildMailWithAttachments(attachmentsManager, renderedMailBody, contentType);
            this.email.setMultipart(multiPart);
        } else {
            this.email.setBody(renderedMailBody);
        }
    }

    private MailAttachmentsManager createAttachmentsManager() {
        AvatarManager avatarManager = (AvatarManager)ComponentAccessor.getComponent(AvatarManager.class);
        AvatarService avatarService = (AvatarService)ComponentAccessor.getComponent(AvatarService.class);
        UserManager userManager = (UserManager)ComponentAccessor.getComponent(UserManager.class);
        ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
        return new MailAttachmentsManagerImpl(avatarService, userManager, avatarManager, applicationProperties);
    }

    private Multipart buildMailWithAttachments(MailAttachmentsManager attachmentsManager, String text, String textContentMimeType) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)text, textContentMimeType);
        multipart.addBodyPart((BodyPart)textPart);
        Iterable bodyParts = Iterables.concat(attachmentsManager.buildAttachmentsBodyParts(), this.attachments);
        for (BodyPart bodyPart : bodyParts) {
            multipart.addBodyPart(bodyPart);
        }
        return multipart;
    }

    public Email render() throws MessagingException {
        this.email.setSubject(this.renderEmailSubject(this.templateParameters));
        this.renderEmailBody(this.templateParameters);
        return this.email;
    }
}

