/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseBannerHelper;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.soy.renderer.SoyException;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseBannerHelperImpl
implements LicenseBannerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseBannerHelperImpl.class);
    static final String EXPIRY_KEY = "license.expiry.remindme";
    static final String MAINTENANCE_KEY = "license.maintenance.remindme";
    private static final int EARLIEST_EXPIRY_WARNING_FROM_EXPIRY = 45;
    private static final String LINK_MANAGE_APPLICATION = "/plugins/servlet/applications/manage";
    private static final int LAST_WEEK_NOTIFICATION = 7;
    private final JiraAuthenticationContext context;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserPropertyManager propertyManager;
    private final JiraLicenseManager jiraLicenseManager;
    private final SoyTemplateRendererProvider rendererProvider;
    private final FeatureManager featureManager;
    private final BaseUrl baseUrl;

    public LicenseBannerHelperImpl(JiraAuthenticationContext context, GlobalPermissionManager globalPermissionManager, UserPropertyManager propertyManager, JiraLicenseManager jiraLicenseManager, SoyTemplateRendererProvider rendererProvider, FeatureManager featureManager, BaseUrl baseUrl) {
        this.context = context;
        this.globalPermissionManager = globalPermissionManager;
        this.propertyManager = propertyManager;
        this.jiraLicenseManager = jiraLicenseManager;
        this.rendererProvider = rendererProvider;
        this.featureManager = featureManager;
        this.baseUrl = baseUrl;
    }

    @Override
    @Nonnull
    public String getExpiryBanner() {
        if (!this.shouldShowLicenseBanners() || !this.jiraLicenseManager.isLicenseSet()) {
            return "";
        }
        int daysFromExpiry = Math.min(this.getHideUntilExpiry(), 45);
        EarliestExpiringLicenseChecker licenseChecker = new EarliestExpiringLicenseChecker(daysFromExpiry, this.jiraLicenseManager.getLicenses());
        ExpirationStateAccumulator subscriptionChecker = licenseChecker.getSubscriptionExpiringLicense();
        if (subscriptionChecker.isExpiring() || subscriptionChecker.getDaysToExpire() <= 7) {
            return this.renderExpiryBanner(subscriptionChecker);
        }
        if (subscriptionChecker.getDaysToExpire() > 45) {
            this.clearHideUntilExpiry();
        }
        return "";
    }

    @Override
    @Nonnull
    public String getMaintenanceFlag() {
        if (!this.shouldShowLicenseBanners() || !this.jiraLicenseManager.isLicenseSet()) {
            return "";
        }
        int daysFromExpiry = Math.min(this.getHideUntilMaintenance(), 45);
        EarliestExpiringLicenseChecker subscriptionChecker = new EarliestExpiringLicenseChecker(daysFromExpiry, this.jiraLicenseManager.getLicenses());
        if (subscriptionChecker.getSubscriptionExpiringLicense().getDaysToExpire() <= 45) {
            return "";
        }
        ExpirationStateAccumulator maintenanceChecker = subscriptionChecker.getMaintenanceExpiringLicense();
        if (!maintenanceChecker.isExpiring()) {
            if (maintenanceChecker.getDaysToExpire() > 45) {
                this.clearHideUtilMaintenance();
            }
            return "";
        }
        return this.renderMaintenanceBanner(maintenanceChecker);
    }

    @Override
    public void remindMeLater() {
        if (!this.shouldShowLicenseBanners()) {
            return;
        }
        if (!this.jiraLicenseManager.isLicenseSet()) {
            this.clearHideUntilExpiry();
            this.clearHideUtilMaintenance();
            return;
        }
        EarliestExpiringLicenseChecker licenseChecker = new EarliestExpiringLicenseChecker(45, this.jiraLicenseManager.getLicenses());
        ExpirationStateAccumulator subscriptionChecker = licenseChecker.getSubscriptionExpiringLicense();
        ExpirationStateAccumulator maintenanceChecker = licenseChecker.getMaintenanceExpiringLicense();
        if (!subscriptionChecker.isExpiring()) {
            this.clearHideUntilExpiry();
            int daysToMaintenanceExpiry = maintenanceChecker.getDaysToExpire();
            if (maintenanceChecker.isExpiring()) {
                if (daysToMaintenanceExpiry <= -7) {
                    this.setHideUtilMaintenance(Integer.MIN_VALUE);
                } else if (daysToMaintenanceExpiry <= 0) {
                    this.setHideUtilMaintenance(daysToMaintenanceExpiry - 7);
                } else if (daysToMaintenanceExpiry <= 7) {
                    this.setHideUtilMaintenance(0);
                } else if (daysToMaintenanceExpiry <= 15) {
                    this.setHideUtilMaintenance(7);
                } else if (daysToMaintenanceExpiry <= 30) {
                    this.setHideUtilMaintenance(15);
                } else {
                    this.setHideUtilMaintenance(30);
                }
            } else {
                this.clearHideUtilMaintenance();
            }
        } else {
            int daysToLicenseExpiry = licenseChecker.getSubscriptionExpiringLicense().getDaysToExpire();
            if (daysToLicenseExpiry <= 7) {
                this.clearHideUntilExpiry();
            } else if (daysToLicenseExpiry <= 15) {
                this.setHideUtilExpiry(7);
            } else if (daysToLicenseExpiry <= 30) {
                this.setHideUtilExpiry(15);
            } else {
                this.setHideUtilExpiry(30);
            }
        }
    }

    @Override
    public void clearRemindMe() {
        if (!this.shouldShowLicenseBanners()) {
            return;
        }
        this.clearHideUntilExpiry();
        this.clearHideUtilMaintenance();
    }

    @Nonnull
    private String renderExpiryBanner(ExpirationStateAccumulator licenseChecker) {
        String templateToRender = licenseChecker.isMultipleExpiring() ? "JIRA.Templates.LicenseBanner.expiryBannerMultiple" : "JIRA.Templates.LicenseBanner.expiryBanner";
        try {
            return this.rendererProvider.getRenderer().render("jira.webresources:soy-templates", templateToRender, (Map)ImmutableMap.of((Object)"days", (Object)licenseChecker.getDaysToExpire(), (Object)"mac", (Object)this.getMacUrl(), (Object)"licenseId", (Object)licenseChecker.getApplicationDescription()));
        }
        catch (SoyException e) {
            LOG.debug("Unable to render banner.", (Throwable)e);
            return "";
        }
    }

    private boolean shouldShowLicenseBanners() {
        return this.havePermission() && !this.featureManager.isOnDemand();
    }

    private String renderMaintenanceBanner(ExpirationStateAccumulator licenseChecker) {
        try {
            String templateToRender = licenseChecker.isMultipleExpiring() ? "JIRA.Templates.LicenseBanner.maintenanceFlagMultiple" : "JIRA.Templates.LicenseBanner.maintenanceFlag";
            return this.rendererProvider.getRenderer().render("jira.webresources:soy-templates", templateToRender, (Map)ImmutableMap.of((Object)"days", (Object)licenseChecker.getDaysToExpire(), (Object)"mac", (Object)this.getMacUrl(), (Object)"licenseId", (Object)licenseChecker.getApplicationDescription()));
        }
        catch (SoyException e) {
            LOG.debug("Unable to render banner.", (Throwable)e);
            return "";
        }
    }

    private String getMacUrl() {
        return this.baseUrl.getBaseUrl() + LINK_MANAGE_APPLICATION;
    }

    private void setHideUtilExpiry(int days) {
        this.setRemindMeDays(days, EXPIRY_KEY);
    }

    private void setHideUtilMaintenance(int days) {
        this.setRemindMeDays(days, MAINTENANCE_KEY);
    }

    private void setRemindMeDays(int days, String key) {
        PropertySet propertySet = this.getPropertySet();
        propertySet.setInt(key, days);
    }

    private void clearHideUntilExpiry() {
        this.clearRemindMeDays(EXPIRY_KEY);
    }

    private void clearHideUtilMaintenance() {
        this.clearRemindMeDays(MAINTENANCE_KEY);
    }

    private void clearRemindMeDays(String key) {
        PropertySet propertySet = this.getPropertySet();
        if (propertySet != null && propertySet.exists(key)) {
            propertySet.remove(key);
        }
    }

    private int getHideUntilMaintenance() {
        return this.getRemindMeDays(MAINTENANCE_KEY);
    }

    private int getHideUntilExpiry() {
        return this.getRemindMeDays(EXPIRY_KEY);
    }

    private int getRemindMeDays(String key) {
        PropertySet propertySet = this.getPropertySet();
        if (propertySet != null && propertySet.exists(key)) {
            return propertySet.getInt(key);
        }
        return Integer.MAX_VALUE;
    }

    private PropertySet getPropertySet() {
        return this.propertyManager.getPropertySet(this.context.getUser());
    }

    private boolean havePermission() {
        ApplicationUser user = this.context.getUser();
        return !Users.isAnonymous((ApplicationUser)user) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private static class EarliestExpiringLicenseChecker {
        ExpirationStateAccumulator subscriptionExpiringLicense = null;
        ExpirationStateAccumulator maintenanceExpiringLicense = null;

        EarliestExpiringLicenseChecker(int notificationPeriod, Iterable<LicenseDetails> theLicenses) {
            this.subscriptionExpiringLicense = new ExpirationStateAccumulator(notificationPeriod){

                @Override
                int getDaysToExpireFrom(@Nonnull LicenseDetails license) {
                    return license.getDaysToLicenseExpiry();
                }
            };
            this.maintenanceExpiringLicense = new ExpirationStateAccumulator(notificationPeriod){

                @Override
                int getDaysToExpireFrom(@Nonnull LicenseDetails license) {
                    return license.getDaysToMaintenanceExpiry();
                }
            };
            for (LicenseDetails license : theLicenses) {
                this.checkLicense(license);
            }
        }

        public ExpirationStateAccumulator getSubscriptionExpiringLicense() {
            return this.subscriptionExpiringLicense;
        }

        public ExpirationStateAccumulator getMaintenanceExpiringLicense() {
            return this.maintenanceExpiringLicense;
        }

        private boolean checkLicense(LicenseDetails license) {
            boolean result = this.subscriptionExpiringLicense.checkLicense(license);
            return result |= this.maintenanceExpiringLicense.checkLicense(license);
        }
    }

    private static abstract class ExpirationStateAccumulator {
        private int daysToExpire = Integer.MAX_VALUE;
        private String applicationDescription = "";
        private int expiringApps = 0;
        int notificationPeriod = 45;

        ExpirationStateAccumulator(int notificationPeriod) {
            this.notificationPeriod = notificationPeriod;
        }

        boolean checkLicense(LicenseDetails license) {
            if (this.ignoreLicense(license)) {
                return false;
            }
            int thisLicenseDaysToExpiry = this.getDaysToExpireFrom(license);
            this.daysToExpire = Math.min(thisLicenseDaysToExpiry, this.daysToExpire);
            if (this.notificationPeriod >= thisLicenseDaysToExpiry) {
                this.expiringApps += license.getLicensedApplications().getKeys().size();
                this.applicationDescription = license.getApplicationDescription();
                return true;
            }
            return false;
        }

        public int getDaysToExpire() {
            return this.daysToExpire;
        }

        public String getApplicationDescription() {
            return this.applicationDescription;
        }

        public boolean isMultipleExpiring() {
            return this.expiringApps > 1;
        }

        public boolean isExpiring() {
            return this.expiringApps > 0;
        }

        private boolean ignoreLicense(LicenseDetails license) {
            return license.isEvaluation() || license.isDeveloper();
        }

        abstract int getDaysToExpireFrom(@Nonnull LicenseDetails var1);
    }
}

