/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.core.util.Clock;
import com.atlassian.core.util.DateUtils;
import com.atlassian.extras.api.Contact;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.license.DefaultLicenseContact;
import com.atlassian.jira.license.DefaultLicenseStatusMessage;
import com.atlassian.jira.license.JiraProductLicense;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.jira.web.util.OutlookDate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLicenseDetails
implements LicenseDetails {
    static final String ENABLED = new String("true");
    @VisibleForTesting
    static final String DATACENTER_PROPERTY_NAME = new String("jira.DataCenter");
    @VisibleForTesting
    static final String ELA_PROPERTY_NAME = new String("ELA");
    static final String ONDEMAND_PROPERTY_NAME = new String("ondemand");
    private static final Logger log = LoggerFactory.getLogger(DefaultLicenseDetails.class);
    private static final int MAINTENANCE_WARNING_PERIOD_IN_DAYS = 42;
    private static final long GRACE_PERIOD_IN_MILLIS = 2592000000L;
    private final JiraProductLicense license;
    private final ApplicationProperties applicationProperties;
    private final ExternalLinkUtil externalLinkUtil;
    private final String licenseString;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper.BeanFactory i18nFactory;
    private final DateTimeFormatter dateTimeFormatter;
    private final Clock clock;
    private final Link urlRenew = new Link("external.link.jira.license.new");
    private final Link urlEvalExpired = new Link("external.link.jira.license.expiredeval");
    private final Link urlSelfRenew = new Link("external.link.jira.license.renew.noncommercial");
    private final Link urlContact = new Link("external.link.jira.license.renew.contact");
    private final Link urlWhyRenew = new Link("external.link.jira.license.whyrenew");

    DefaultLicenseDetails(@Nonnull JiraProductLicense license, @Nonnull String licenseString, @Nonnull ApplicationProperties applicationProperties, @Nonnull ExternalLinkUtil externalLinkUtil, @Nonnull BuildUtilsInfo buildUtilsInfo, @Nonnull I18nHelper.BeanFactory i18nFactory, @Nonnull DateTimeFormatter dateTimeFormatter, @Nonnull Clock clock) {
        this.i18nFactory = i18nFactory;
        this.dateTimeFormatter = dateTimeFormatter;
        this.licenseString = (String)Assertions.notNull((String)"licenseString", (Object)licenseString);
        this.license = (JiraProductLicense)Assertions.notNull((String)"license", (Object)license);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.clock = (Clock)Assertions.notNull((String)"clock", (Object)clock);
    }

    static boolean isDataCenterLicense(@Nonnull JiraLicense license) {
        return ENABLED.equals(license.getProperty(DATACENTER_PROPERTY_NAME));
    }

    static boolean isELA(@Nonnull JiraLicense license) {
        return ENABLED.equals(license.getProperty(ELA_PROPERTY_NAME));
    }

    static boolean isEnterpriseSubscriptionLicense(@Nonnull JiraLicense license) {
        return DefaultLicenseDetails.isDataCenterLicense(license) || DefaultLicenseDetails.isELA(license);
    }

    private boolean isFullLicense() {
        return LicenseType.COMMERCIAL == this.getLicenseType() && !this.license.isEvaluation();
    }

    public boolean isPersonalLicense() {
        return LicenseType.PERSONAL == this.getLicenseType();
    }

    private boolean isEvaluationLicense() {
        return this.license.isEvaluation();
    }

    private boolean isAcademicLicense() {
        return LicenseType.ACADEMIC == this.getLicenseType();
    }

    private boolean isNonProfitLicense() {
        return LicenseType.NON_PROFIT == this.getLicenseType();
    }

    private boolean isCommunityLicense() {
        return LicenseType.COMMUNITY == this.getLicenseType();
    }

    private boolean isOpenSourceLicense() {
        return LicenseType.OPEN_SOURCE == this.getLicenseType();
    }

    private boolean isDeveloperLicense() {
        return LicenseType.DEVELOPER == this.getLicenseType();
    }

    private boolean isDemonstrationLicense() {
        return LicenseType.DEMONSTRATION == this.getLicenseType();
    }

    private boolean isCommercialLicense() {
        return this.isFullLicense() || this.isAcademicLicense() || this.isEvaluationLicense() || LicenseType.HOSTED == this.getLicenseType();
    }

    private boolean isSelfRenewable() {
        return this.isCommunityLicense() || this.isOpenSourceLicense() || this.isDeveloperLicense() || this.isPersonalLicense();
    }

    private boolean isNonCommercialNonRenewable() {
        return this.isNonProfitLicense() || this.isDemonstrationLicense() || LicenseType.TESTING == this.getLicenseType();
    }

    private String localisedMaintenanceExpiryDate(I18nHelper i18n) {
        DateTimeFormatter dmyFormatter = this.dateTimeFormatter.withLocale(i18n.getLocale()).withStyle(DateTimeStyle.DATE);
        Date maintenanceExpiryDate = this.getMaintenanceExpiryDate();
        return maintenanceExpiryDate == null ? i18n.getText("common.words.unlimited") : dmyFormatter.format(maintenanceExpiryDate);
    }

    DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public boolean isEntitledToSupport() {
        return !this.isNonCommercialNonRenewable() && !this.isPersonalLicense();
    }

    public boolean isLicenseAlmostExpired() {
        if (this.isEvaluationLicense() || this.isNewBuildWithOldLicense()) {
            Date expiry = this.getLicenseExpiry();
            return expiry != null && expiry.getTime() - this.getCurrentTime() < 7L * DateUtils.DAY_MILLIS;
        }
        return false;
    }

    public boolean isExpired() {
        if (this.isEvaluationLicense()) {
            return this.license.isExpired();
        }
        if (this.isNewBuildWithOldLicense()) {
            return this.isExtendLicenseExpired();
        }
        return false;
    }

    public String getPurchaseDate(OutlookDate outlookDate) {
        return ((OutlookDate)Assertions.notNull((String)"outlookDate", (Object)outlookDate)).formatDMY(this.license.getPurchaseDate());
    }

    public boolean isEvaluation() {
        boolean isEvaluation = this.license.isEvaluation();
        if (!isEvaluation && !Strings.isNullOrEmpty((String)this.license.getProperty("jira.TrialEndDate"))) {
            isEvaluation = true;
        }
        return isEvaluation;
    }

    public boolean isStarter() {
        return LicenseType.STARTER.equals((Object)this.license.getLicenseType());
    }

    public boolean isCommercial() {
        return LicenseType.COMMERCIAL.equals((Object)this.license.getLicenseType());
    }

    public boolean isCommunity() {
        return LicenseType.COMMUNITY.equals((Object)this.license.getLicenseType());
    }

    public boolean isOpenSource() {
        return LicenseType.OPEN_SOURCE.equals((Object)this.license.getLicenseType());
    }

    public boolean isNonProfit() {
        return LicenseType.NON_PROFIT.equals((Object)this.license.getLicenseType());
    }

    public boolean isDemonstration() {
        return LicenseType.DEMONSTRATION.equals((Object)this.license.getLicenseType());
    }

    public boolean isOnDemand() {
        return ENABLED.equals(this.license.getProperty(ONDEMAND_PROPERTY_NAME));
    }

    public boolean isDataCenter() {
        return DefaultLicenseDetails.isDataCenterLicense(this.license);
    }

    public boolean isEnterpriseLicenseAgreement() {
        return DefaultLicenseDetails.isELA(this.license);
    }

    public boolean isDeveloper() {
        return LicenseType.DEVELOPER.equals((Object)this.license.getLicenseType());
    }

    public JiraLicense getJiraLicense() {
        return this.license;
    }

    @Nonnull
    public LicensedApplications getLicensedApplications() {
        return this.license.getApplications();
    }

    public String getOrganisation() {
        return this.license.getOrganisation() == null ? "<Unknown>" : this.license.getOrganisation().getName();
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public boolean isMaintenanceValidForBuildDate(Date currentBuildDate) {
        return this.license.getMaintenanceExpiryDate() == null || this.license.getMaintenanceExpiryDate().compareTo(currentBuildDate) >= 0;
    }

    public String getSupportEntitlementNumber() {
        return this.license.getSupportEntitlementNumber();
    }

    public Collection<LicenseDetails.LicenseContact> getContacts() {
        ArrayList licenseContacts = Lists.newArrayList();
        for (Contact contact : this.license.getContacts()) {
            if (contact == null) continue;
            licenseContacts.add(new DefaultLicenseContact(contact.getName(), contact.getEmail()));
        }
        return licenseContacts;
    }

    public int getDaysToLicenseExpiry() {
        return this.getDaysUntilDate(this.getLicenseExpiry());
    }

    public int getDaysToMaintenanceExpiry() {
        return this.getDaysUntilDate(this.getMaintenanceExpiryDate());
    }

    public LicenseType getLicenseType() {
        return this.getJiraLicense().getLicenseType();
    }

    @Nonnull
    public String getApplicationDescription() {
        String desc = this.getLicensedApplications().getDescription();
        return desc.isEmpty() ? "JIRA" : desc;
    }

    private int getDaysUntilDate(Date date) {
        if (date == null) {
            return Integer.MAX_VALUE;
        }
        double days = (double)(date.getTime() - this.clock.getCurrentDate().getTime()) / (double)TimeUnit.DAYS.toMillis(1L);
        return (int)Math.floor(days);
    }

    Date getLicenseExpiry() {
        if (this.isEvaluationLicense()) {
            return this.license.getExpiryDate();
        }
        if (this.isNewBuildWithOldLicense()) {
            return this.getExtendedLicenseExpiry();
        }
        return null;
    }

    private Date getExtendedLicenseExpiry() {
        long installationWithExpiredLicenseDate = Long.parseLong(this.getConfirmedInstallWithOldLicenseTimestamp());
        return new Date(installationWithExpiredLicenseDate + 2592000000L);
    }

    private boolean isNewBuildWithOldLicense() {
        boolean hasLicenseTooOldForBuildConfirmationBeenDone = this.applicationProperties.getOption("jira.install.oldlicense.confirmed");
        return !this.isMaintenanceValidForBuildDate(this.getCurrentBuildDate()) && hasLicenseTooOldForBuildConfirmationBeenDone;
    }

    private String getTimeUntilExpiry(I18nHelper i18n) {
        return DateUtils.dateDifference((long)this.getCurrentTime(), (long)this.getLicenseExpiry().getTime(), (long)2L, (ResourceBundle)i18n.getDefaultResourceBundle());
    }

    private boolean isMaintenanceAlmostEnded() {
        return this.license.getNumberOfDaysBeforeMaintenanceExpiry() < 42;
    }

    private boolean isMaintenanceExpired() {
        return this.license.isMaintenanceExpired();
    }

    @Nullable
    public Date getMaintenanceExpiryDate() {
        return this.license.getMaintenanceExpiryDate();
    }

    private boolean isExtendLicenseExpired() {
        try {
            return this.getCurrentTime() > this.getExtendedLicenseExpiry().getTime();
        }
        catch (NumberFormatException e) {
            log.debug("The Confirm Install Timestamp does not exist or is in the wrong format.", (Throwable)e);
            return false;
        }
    }

    private String getConfirmedInstallWithOldLicenseTimestamp() {
        return this.applicationProperties.getString("jira.install.oldlicense.confirmed.timestamp");
    }

    ApplicationUser getConfirmedUser(UserManager userManager) {
        String userName = this.applicationProperties.getString("jira.install.oldlicense.confirmed.user");
        ApplicationUser user = null;
        if (userName != null && (user = userManager.getUserByName(userName)) == null) {
            log.warn("Could not find user [" + userName + "]");
        }
        return user;
    }

    final long getCurrentTime() {
        return this.clock.getCurrentDate().getTime();
    }

    private String getCurrentVersion() {
        return this.buildUtilsInfo.getVersion();
    }

    private Date getCurrentBuildDate() {
        return this.buildUtilsInfo.getCurrentBuildDate();
    }

    public String getMaintenanceEndString(OutlookDate outlookDate) {
        Date end = this.isEvaluationLicense() || this.isNewBuildWithOldLicense() ? this.getLicenseExpiry() : this.getMaintenanceExpiryDate();
        return end == null ? "Unlimited" : outlookDate.formatDMY(end);
    }

    public boolean isUnlimitedNumberOfUsers() {
        if (this.isOnDemand()) {
            return true;
        }
        return this.license.isUnlimitedNumberOfUsers();
    }

    public int getLicenseVersion() {
        return this.license.getLicenseVersion();
    }

    public String getDescription() {
        return this.license.getDescription();
    }

    public String getPartnerName() {
        return this.license.getPartner() == null ? null : this.license.getPartner().getName();
    }

    public String getLicenseExpiryStatusMessage(@Nullable ApplicationUser user) {
        return this.getLicenseExpiryStatusMessage(this.i18nFactory.getInstance(user), null);
    }

    public String getLicenseExpiryStatusMessage(I18nHelper i18n, @Nullable OutlookDate outlookDate) {
        String msg;
        if (this.isEvaluationLicense() || this.isNewBuildWithOldLicense()) {
            if (this.isExpired()) {
                msg = i18n.getText("admin.license.expired");
            } else {
                DateTimeFormatter dmyFormatter = this.dateTimeFormatter.withLocale(i18n.getLocale()).withStyle(DateTimeStyle.DATE);
                msg = i18n.getText("admin.license.expiresin", this.getTimeUntilExpiry(i18n), dmyFormatter.format(this.getLicenseExpiry()));
            }
        } else if (!this.isMaintenanceExpired()) {
            msg = this.isEntitledToSupport() ? i18n.getText("admin.support.available.until", "<b>" + this.localisedMaintenanceExpiryDate(i18n) + "</b>") : i18n.getText("admin.upgrades.available.until", "<b>" + this.localisedMaintenanceExpiryDate(i18n) + "</b>");
        } else {
            return null;
        }
        return "(" + msg + ")";
    }

    public String getBriefMaintenanceStatusMessage(I18nHelper i18n) {
        String msg;
        if (!this.isEntitledToSupport()) {
            msg = i18n.getText("admin.license.maintenance.status.unsupported");
        } else {
            msg = i18n.getText("admin.license.maintenance.status.supported.valid");
            if (this.isEvaluationLicense() || this.isNewBuildWithOldLicense()) {
                if (this.isExpired()) {
                    msg = i18n.getText("admin.license.maintenance.status.supported.expired");
                }
            } else if (this.isMaintenanceExpired()) {
                msg = i18n.getText("admin.license.maintenance.status.supported.expired");
            }
        }
        return msg;
    }

    public LicenseDetails.LicenseStatusMessage getMaintenanceMessage(@Nonnull I18nHelper i18n, String applicationName) {
        String renewKey;
        String supportAndUpdates;
        String maintenancePeriodEnd = "<strong>" + TextUtils.htmlEncode((String)this.localisedMaintenanceExpiryDate(i18n)) + "</strong>";
        if (this.isEntitledToSupport()) {
            supportAndUpdates = i18n.getText("admin.license.support.and.updates.has.ended", maintenancePeriodEnd, applicationName);
            renewKey = "admin.license.renew.for.support.and.updates";
        } else {
            supportAndUpdates = i18n.getText("admin.license.updates.only.has.ended", maintenancePeriodEnd, applicationName);
            String string = renewKey = this.isSelfRenewable() ? "admin.license.renew.for.updates.only" : "admin.license.renew.for.deprecated";
        }
        Link renewLink = this.isCommercialLicense() ? this.urlRenew : (this.isSelfRenewable() ? this.urlSelfRenew : this.urlContact);
        String renew = i18n.getText(renewKey, renewLink.getStart(), renewLink.getEnd());
        String whyRenew = i18n.getText("admin.license.why.renew", this.urlWhyRenew.getStart(), this.urlWhyRenew.getEnd());
        return DefaultLicenseStatusMessage.builder().add("admin.license.support.and.updates", supportAndUpdates).add("admin.license.renewal.target", Joiner.on((String)" ").join((Object)renew, (Object)whyRenew, new Object[0])).build();
    }

    public String getLicenseStatusMessage(@Nullable ApplicationUser user, String delimiter, UserManager userManager) {
        return this.getLicenseStatusMessage(this.i18nFactory.getInstance(user), null, delimiter, userManager);
    }

    public String getLicenseStatusMessage(I18nHelper i18n, @Nullable OutlookDate ignored, String delimiter, UserManager userManager) {
        LicenseDetails.LicenseStatusMessage licenseStatusMessage = this.getLicenseStatusMessage(i18n, userManager);
        if (licenseStatusMessage != null) {
            return licenseStatusMessage.getAllMessages(delimiter);
        }
        return null;
    }

    public LicenseDetails.LicenseStatusMessage getLicenseStatusMessage(I18nHelper i18n, UserManager userManager) {
        if (this.isEvaluationLicense()) {
            DateTimeFormatter dmyFormatter = this.dateTimeFormatter.withLocale(i18n.getLocale()).withStyle(DateTimeStyle.DATE);
            String licenseExpiry = "<strong>" + TextUtils.htmlEncode((String)dmyFormatter.format(this.getLicenseExpiry())) + "</strong>";
            if (this.isExpired()) {
                return DefaultLicenseStatusMessage.builder().add("admin.license.evaluation", i18n.getText("admin.license.evaluation.expired", licenseExpiry)).add("admin.license.evaluation.renew", i18n.getText("admin.license.evaluation.expired.renew", this.urlEvalExpired.getStart(), this.urlEvalExpired.getEnd())).build();
            }
            if (this.isLicenseAlmostExpired()) {
                return DefaultLicenseStatusMessage.builder().add("admin.license.evaluation", i18n.getText("admin.license.evaluation.almost.expired", licenseExpiry)).add("admin.license.evaluation.renew", i18n.getText("admin.license.evaluation.almost.expired.renew", this.urlEvalExpired.getStart(), this.urlEvalExpired.getEnd())).build();
            }
            return null;
        }
        if (this.isNewBuildWithOldLicense()) {
            String renewKey;
            String supportAndUpdates;
            String maintenanceEnd = "<strong>" + TextUtils.htmlEncode((String)this.localisedMaintenanceExpiryDate(i18n)) + "</strong>";
            String extendedDaysLeft = this.getTimeUntilExpiry(i18n);
            ApplicationUser user = this.getConfirmedUser(userManager);
            String currentVersion = user != null ? i18n.getText("admin.license.nbol.current.version", this.getCurrentVersion(), user.getDisplayName(), user.getName()) : i18n.getText("admin.license.nbol.current.version.user.unknown", this.getCurrentVersion());
            if (this.isEntitledToSupport()) {
                supportAndUpdates = i18n.getText("admin.license.nbol.support.and.updates", maintenanceEnd);
                renewKey = "admin.license.renew.for.support.and.updates";
            } else {
                supportAndUpdates = i18n.getText("admin.license.nbol.updates.only", maintenanceEnd);
                String string = renewKey = this.isSelfRenewable() ? "admin.license.renew.for.updates.only" : "admin.license.renew.for.deprecated";
            }
            Link renewLink = this.isCommercialLicense() ? this.urlRenew : (this.isSelfRenewable() ? this.urlSelfRenew : this.urlContact);
            String renew = i18n.getText(renewKey, renewLink.getStart(), renewLink.getEnd());
            String expired = this.isExpired() ? i18n.getText("admin.license.nbol.evaluation.period.has.expired") : i18n.getText("admin.license.nbol.evaluation.period.will.expire.in", "<strong>" + extendedDaysLeft + "</strong>");
            String whyRenew = i18n.getText("admin.license.why.renew", this.urlWhyRenew.getStart(), this.urlWhyRenew.getEnd());
            return DefaultLicenseStatusMessage.builder().add("admin.license.support.and.updates", supportAndUpdates).add("admin.license.nbol.current.version", currentVersion).add("admin.license.nbol.evaluation.expiration", expired).add("admin.license.renewal.target", Joiner.on((String)" ").join((Object)renew, (Object)whyRenew, new Object[0])).build();
        }
        String maintenancePeriodEnd = "<strong>" + TextUtils.htmlEncode((String)this.localisedMaintenanceExpiryDate(i18n)) + "</strong>";
        if (this.isMaintenanceExpired()) {
            return this.getMaintenanceMessage(i18n, "JIRA");
        }
        if (this.isMaintenanceAlmostEnded()) {
            String renewKey;
            String supportAndUpdates;
            if (this.isEntitledToSupport()) {
                supportAndUpdates = i18n.getText("admin.license.support.and.updates.will.end", maintenancePeriodEnd);
                renewKey = "admin.license.renew.for.support.and.updates.after";
            } else {
                supportAndUpdates = i18n.getText("admin.license.updates.only.will.end", maintenancePeriodEnd);
                String string = renewKey = this.isSelfRenewable() ? "admin.license.renew.for.updates.only.after" : "admin.license.renew.for.deprecated.after";
            }
            Link renewLink = this.isCommercialLicense() ? this.urlRenew : (this.isSelfRenewable() ? this.urlSelfRenew : this.urlContact);
            String renew = i18n.getText(renewKey, renewLink.getStart(), renewLink.getEnd());
            String whyRenew = i18n.getText("admin.license.why.renew", this.urlWhyRenew.getStart(), this.urlWhyRenew.getEnd());
            return DefaultLicenseStatusMessage.builder().add("admin.license.support.and.updates", supportAndUpdates).add("admin.license.renewal.target", Joiner.on((String)" ").join((Object)renew, (Object)whyRenew, new Object[0])).build();
        }
        if (!this.isDataCenter() && this.isClustered()) {
            String supportAndUpdates = i18n.getText("admin.data.center.unlicensed");
            String MAC = this.getExternalLinkUtil().getProperty("external.link.jira.license.data.center.contact");
            String renew = i18n.getText("admin.data.center.unlicensed.buy.now", "<a href='" + MAC + "'>", "</a>");
            return DefaultLicenseStatusMessage.builder().add("admin.license.support.and.updates", supportAndUpdates).add("admin.license.renewal.target", renew).build();
        }
        return null;
    }

    private boolean isClustered() {
        return ((ClusterManager)ComponentAccessor.getComponent(ClusterManager.class)).isClustered();
    }

    ExternalLinkUtil getExternalLinkUtil() {
        return this.externalLinkUtil;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof LicenseDetails)) {
            return false;
        }
        return this.getLicenseString().equals(((LicenseDetails)other).getLicenseString());
    }

    public int hashCode() {
        return this.getLicenseString().hashCode();
    }

    public class Link {
        private final String key;
        private final String param0;

        private Link(String key) {
            this.key = key;
            this.param0 = null;
        }

        public String getStart() {
            String url = this.param0 == null ? DefaultLicenseDetails.this.externalLinkUtil.getProperty(this.key) : DefaultLicenseDetails.this.externalLinkUtil.getProperty(this.key, this.param0);
            return "<a href=\"" + url + "\">";
        }

        public String getEnd() {
            return "</a>";
        }
    }
}

