/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

@EventComponent
public class DefaultLicenseCountService
implements LicenseCountService {
    private final CachedReference<Integer> billableUsersCount;
    private final EventPublisher eventPublisher;

    public DefaultLicenseCountService(CacheManager cacheManager, GlobalPermissionManager globalPermissionManager, CrowdService crowdService, FeatureManager featureManager, EventPublisher eventPublisher, GroupManager groupManager, ApplicationRoleManager applicationRoleManager) {
        this.eventPublisher = eventPublisher;
        this.billableUsersCount = cacheManager.getCachedReference(DefaultLicenseCountService.class.getName() + ".billableUsersCount", (Supplier)new BillableUserCountLoader(globalPermissionManager, crowdService, featureManager, groupManager, applicationRoleManager), new CacheSettingsBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build());
    }

    public int totalBillableUsers() {
        return (Integer)this.billableUsersCount.get();
    }

    public void flush() {
        this.billableUsersCount.reset();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent ignored) {
        this.flush();
        this.eventPublisher.publish((Object)new XMLRestoreFinishedEvent((Object)this));
    }

    @EventListener
    public void onDirectoryModified(DirectoryEvent ignored) {
        this.flush();
    }

    @EventListener
    public void onDirectorySynchronisation(RemoteDirectorySynchronisedEvent ignored) {
        this.flush();
    }

    @EventListener
    public void onDarkFeatureEvent(FeatureEvent event) {
        if (CoreFeatures.forFeatureKey((String)event.feature()) == CoreFeatures.LICENSE_ROLES_ENABLED) {
            this.flush();
        }
    }

    private static final class BillableUserCountLoader
    extends CountLoader
    implements Supplier<Integer> {
        public static final Pattern CONNECT_USER_ATTRIBUTE_PATTERN = Pattern.compile("^synch\\..*\\.atlassian-connect-user$");
        private final GlobalPermissionManager globalPermissionManager;
        private final FeatureManager featureManager;
        private final GroupManager groupManager;

        private BillableUserCountLoader(GlobalPermissionManager globalPermissionManager, CrowdService crowdService, FeatureManager featureManager, GroupManager groupManager, ApplicationRoleManager applicationRoleManager) {
            super(crowdService, globalPermissionManager, applicationRoleManager);
            this.globalPermissionManager = globalPermissionManager;
            this.featureManager = featureManager;
            this.groupManager = groupManager;
        }

        private Iterable<ApplicationUser> getGroupMembers(Group group) {
            return Iterables.transform(this.getGroupMemberUsers(group), (Function)new Function<User, ApplicationUser>(){

                public ApplicationUser apply(@Nullable User input) {
                    return ApplicationUsers.from(input);
                }
            });
        }

        public Integer get() {
            Set<Group> groupsThatGrantUserAccess = this.getGroupsThatGrantUserAccess();
            HashSet allUsers = new HashSet();
            boolean onDemand = this.featureManager.isOnDemand();
            for (Group group : groupsThatGrantUserAccess) {
                Iterable<ApplicationUser> users = this.getGroupMembers(group);
                Set collect = StreamSupport.stream(users.spliterator(), false).filter(ApplicationUser::isActive).filter(user -> !onDemand || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)).filter(user -> !this.isConnect((ApplicationUser)user)).map(user -> IdentifierUtils.toLowerCase((String)user.getUsername())).collect(Collectors.toSet());
                allUsers.addAll(collect);
            }
            return allUsers.size();
        }

        private boolean isConnect(ApplicationUser user) {
            boolean hasConnectAttribute;
            UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getUsername());
            if (userWithAttributes != null && (hasConnectAttribute = userWithAttributes.getKeys().stream().filter(key -> CONNECT_USER_ATTRIBUTE_PATTERN.matcher((CharSequence)key).matches()).anyMatch(key -> "true".equals(userWithAttributes.getValue(key))))) {
                return true;
            }
            if (user.getName().startsWith("addon_")) {
                Collection groupsForUser = this.groupManager.getGroupsForUser(user);
                return Iterables.any((Iterable)groupsForUser, group -> group.getName().equals("atlassian-addons"));
            }
            return false;
        }
    }

    private static abstract class CountLoader {
        protected final CrowdService crowdService;
        private final GlobalPermissionManager globalPermissionManager;
        private final ApplicationRoleManager applicationRoleManager;

        protected CountLoader(CrowdService crowdService, GlobalPermissionManager globalPermissionManager, ApplicationRoleManager applicationRoleManager) {
            this.crowdService = crowdService;
            this.globalPermissionManager = globalPermissionManager;
            this.applicationRoleManager = applicationRoleManager;
        }

        Iterable<User> getGroupMemberUsers(Group group) {
            MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1);
            return this.crowdService.search((Query)membershipQuery);
        }

        Set<Group> getGroupsThatGrantUserAccess() {
            if (this.applicationRoleManager.rolesEnabled()) {
                return this.applicationRoleManager.getGroupsForLicensedRoles();
            }
            HashSet<Group> groupsWithUsePermission = new HashSet<Group>();
            groupsWithUsePermission.addAll(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.USE));
            groupsWithUsePermission.addAll(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.ADMINISTER));
            groupsWithUsePermission.addAll(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN));
            return groupsWithUsePermission;
        }
    }
}

