/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.license.LicenseDetails;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

@ExperimentalApi
public class ConfirmEvaluationLicenseEvent {
    private final String userWhoConfirmed;
    private final Iterable<LicenseDetails> expiredLicenses;

    public ConfirmEvaluationLicenseEvent(@Nonnull String userWhoConfirmed, @Nonnull Iterable<LicenseDetails> expiredLicenses) {
        Preconditions.checkNotNull((Object)userWhoConfirmed, (Object)"UserWhoConfirmed");
        Preconditions.checkNotNull(expiredLicenses, (Object)"expiredLicenses");
        this.userWhoConfirmed = userWhoConfirmed;
        this.expiredLicenses = ImmutableList.copyOf(expiredLicenses);
    }

    @Nonnull
    public String getUserWhoConfirmed() {
        return this.userWhoConfirmed;
    }

    public Iterable<LicenseDetails> getExpiredLicenses() {
        return this.expiredLicenses;
    }
}

