/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.bc.project.component.LocaleSensitiveProjectComponentNameComparator;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class ComponentClauseValuesGenerator
implements ClauseValuesGenerator {
    private final ProjectComponentManager projectComponentManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;

    public ComponentClauseValuesGenerator(ProjectComponentManager projectComponentManager, ProjectManager projectManager, PermissionManager permissionManager) {
        this.projectComponentManager = projectComponentManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList projectComponents = new ArrayList(this.projectComponentManager.findAll());
        Collections.sort(projectComponents, new LocaleSensitiveProjectComponentNameComparator(this.getLocale(searcher)));
        ApplicationUser sercherApplicationUser = searcher;
        LinkedHashSet<ClauseValuesGenerator.Result> componentValues = new LinkedHashSet<ClauseValuesGenerator.Result>();
        for (ProjectComponent component : projectComponents) {
            Project project;
            if (componentValues.size() == maxNumResults) break;
            String lowerCaseCompName = component.getName().toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseCompName.startsWith(valuePrefix.toLowerCase()) || (project = this.projectManager.getProjectObj(component.getProjectId())) == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, sercherApplicationUser)) continue;
            componentValues.add(new ClauseValuesGenerator.Result(component.getName()));
        }
        return new ClauseValuesGenerator.Results(new ArrayList(componentValues));
    }

    Locale getLocale(ApplicationUser searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

