/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.List;

class IntegerValueValidator {
    private final JqlOperandResolver operandResolver;

    IntegerValueValidator(JqlOperandResolver operandResolver) {
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
    }

    MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        Assertions.notNull((String)"terminalClause", (Object)terminalClause);
        Operand operand = terminalClause.getOperand();
        MessageSetImpl messages = new MessageSetImpl();
        if (this.operandResolver.isValidOperand(operand)) {
            I18nHelper i18n = this.getI18n(searcher);
            List values = this.operandResolver.getValues(searcher, operand, terminalClause);
            String fieldName = terminalClause.getName();
            for (QueryLiteral value : values) {
                boolean isValid = true;
                String str = value.getStringValue();
                if (str != null) {
                    try {
                        Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        isValid = false;
                    }
                }
                if (isValid) continue;
                String msg = this.operandResolver.isFunctionOperand(value.getSourceOperand()) ? i18n.getText("jira.jql.clause.integer.format.invalid.from.func", value.getSourceOperand().getName(), fieldName) : i18n.getText("jira.jql.clause.integer.format.invalid", str, fieldName);
                messages.addErrorMessage(msg);
            }
        }
        return messages;
    }

    I18nHelper getI18n(ApplicationUser user) {
        return new I18nBean(user);
    }
}

