/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.query.CommentClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProjectRoleAndGroupPermissionsDecorator {
    private static final Logger log = LoggerFactory.getLogger(CommentClauseQueryFactory.class);
    public static final BooleanQuery matchNoDocsQuery = new BooleanQuery();
    private final PermissionManager permissionManager;
    private final ProjectRoleManager projectRoleManager;

    public QueryProjectRoleAndGroupPermissionsDecorator(PermissionManager permissionManager, ProjectRoleManager projectRoleManager) {
        this.permissionManager = permissionManager;
        this.projectRoleManager = projectRoleManager;
    }

    public Query appendPermissionFilterQuery(Query query, QueryCreationContext queryCreationContext, String groupLevelField, String roleLevelField) {
        Query permissionFilterQuery = this.createPermissionQuery(queryCreationContext, groupLevelField, roleLevelField);
        if (permissionFilterQuery != matchNoDocsQuery) {
            BooleanQuery queryWithFilter = new BooleanQuery();
            queryWithFilter.add(query, BooleanClause.Occur.MUST);
            queryWithFilter.add(permissionFilterQuery, BooleanClause.Occur.MUST);
            return queryWithFilter;
        }
        return new BooleanQuery();
    }

    public Query decorateWorklogQueryWithPermissionChecks(Query query, QueryCreationContext queryCreationContext) {
        return this.appendPermissionFilterQuery(query, queryCreationContext, "worklog_level", "worklog_role_level");
    }

    public Query createPermissionQuery(QueryCreationContext queryCreationContext, String groupLevelField, String roleLevelField) {
        if (queryCreationContext.isSecurityOverriden()) {
            return new MatchAllDocsQuery();
        }
        List<Long> projectIds = this.getVisibleProjectIds(queryCreationContext.getApplicationUser());
        if (projectIds.isEmpty()) {
            return matchNoDocsQuery;
        }
        BooleanQuery levelQuery = this.createLevelRestrictionQuery(projectIds, queryCreationContext.getApplicationUser(), groupLevelField, roleLevelField);
        BooleanQuery projectVisibilityQuery = this.createProjectVisibilityQuery(projectIds);
        BooleanQuery indexQuery = new BooleanQuery();
        indexQuery.add((Query)levelQuery, BooleanClause.Occur.MUST);
        indexQuery.add((Query)projectVisibilityQuery, BooleanClause.Occur.MUST);
        return indexQuery;
    }

    TermQuery getTermQuery(String documentConstant, String value) {
        return new TermQuery(new Term(documentConstant, value));
    }

    BooleanQuery createProjectVisibilityQuery(List<Long> projectIds) {
        BooleanQuery visibilityQuery = new BooleanQuery();
        String projectIndexField = SystemSearchConstants.forProject().getIndexField();
        for (Long projectId : projectIds) {
            visibilityQuery.add((Query)this.getTermQuery(projectIndexField, projectId.toString()), BooleanClause.Occur.SHOULD);
        }
        return visibilityQuery;
    }

    BooleanQuery createLevelRestrictionQuery(List<Long> projectIds, ApplicationUser searcher, String groupLevelField, String roleLevelField) {
        BooleanQuery levelQuery = new BooleanQuery();
        Query noGroupOrLevelConstraints = this.createNoGroupOrProjectRoleLevelQuery(groupLevelField, roleLevelField);
        levelQuery.add(noGroupOrLevelConstraints, BooleanClause.Occur.SHOULD);
        if (searcher != null) {
            ProjectRoleManager.ProjectIdToProjectRoleIdsMap projectIdToProjectRolesMap;
            Set<String> groups = this.getGroups(searcher);
            if (!groups.isEmpty()) {
                levelQuery.add(this.createGroupLevelQuery(groups, groupLevelField), BooleanClause.Occur.SHOULD);
            }
            if (!(projectIdToProjectRolesMap = this.projectRoleManager.createProjectIdToProjectRolesMap(searcher, projectIds)).isEmpty()) {
                Query query = this.createProjectRoleLevelQuery(projectIdToProjectRolesMap, roleLevelField);
                levelQuery.add(query, BooleanClause.Occur.SHOULD);
            }
        }
        return levelQuery;
    }

    Set<String> getGroups(ApplicationUser searcher) {
        UserUtil userUtil = (UserUtil)ComponentAccessor.getComponent(UserUtil.class);
        return userUtil.getGroupNamesForUser(searcher.getName());
    }

    Query createNoGroupOrProjectRoleLevelQuery(String groupLevelField, String roleLevelField) {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)this.getTermQuery(groupLevelField, "-1"), BooleanClause.Occur.MUST);
        query.add((Query)this.getTermQuery(roleLevelField, "-1"), BooleanClause.Occur.MUST);
        return query;
    }

    Query createProjectRoleLevelQuery(ProjectRoleManager.ProjectIdToProjectRoleIdsMap projectIdToProjectRolesMap, String roleLevelField) {
        BooleanQuery query = new BooleanQuery();
        if (projectIdToProjectRolesMap == null || projectIdToProjectRolesMap.isEmpty()) {
            log.debug("Groups must be specified!");
            return query;
        }
        for (ProjectRoleManager.ProjectIdToProjectRoleIdsMap.Entry entry : projectIdToProjectRolesMap) {
            Long projectId = entry.getProjectId();
            List projectRoles = entry.getProjectRoleIds();
            for (Long projectRoleId : projectRoles) {
                query.add(this.createFieldInProjectAndUserInRoleQuery(projectId, projectRoleId, roleLevelField), BooleanClause.Occur.SHOULD);
            }
        }
        return query;
    }

    Query createFieldInProjectAndUserInRoleQuery(Long projectId, Long projectRoleId, String roleLevelField) {
        BooleanQuery query = new BooleanQuery();
        if (projectId == null) {
            log.debug("projectId must be specified!");
            return query;
        }
        if (projectRoleId == null) {
            log.debug("projectRoleId must be specified!");
            return query;
        }
        query.add((Query)this.getTermQuery(SystemSearchConstants.forProject().getIndexField(), projectId.toString()), BooleanClause.Occur.MUST);
        query.add((Query)this.getTermQuery(roleLevelField, projectRoleId.toString()), BooleanClause.Occur.MUST);
        return query;
    }

    Query createGroupLevelQuery(Set<String> groups, String groupLevelField) {
        BooleanQuery query = new BooleanQuery();
        if (groups == null || groups.isEmpty()) {
            log.debug("Groups must be specified!");
            return query;
        }
        for (String group : groups) {
            query.add((Query)this.getTermQuery(groupLevelField, group), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    List<Long> getVisibleProjectIds(ApplicationUser searcher) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, searcher);
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (Project project : projects) {
            if (project == null) continue;
            projectIds.add(project.getId());
        }
        return projectIds;
    }
}

