/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.LinkedHashSet;

public class DefaultOperandSanitisingVisitor
implements OperandVisitor<Operand> {
    private final JqlOperandResolver jqlOperandResolver;
    private final ApplicationUser searcher;

    public DefaultOperandSanitisingVisitor(JqlOperandResolver jqlOperandResolver, ApplicationUser searcher) {
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.searcher = searcher;
    }

    public Operand visit(EmptyOperand empty) {
        return empty;
    }

    public Operand visit(FunctionOperand function) {
        return this.jqlOperandResolver.sanitiseFunctionOperand(this.searcher, function);
    }

    public Operand visit(MultiValueOperand originalMulti) {
        boolean isModified = false;
        LinkedHashSet<Operand> sanitisedOperands = new LinkedHashSet<Operand>();
        for (Operand childOperand : originalMulti.getValues()) {
            Operand sanitisedChild = (Operand)childOperand.accept((OperandVisitor)this);
            if (!sanitisedChild.equals(childOperand)) {
                isModified = true;
            }
            sanitisedOperands.add(sanitisedChild);
        }
        return isModified ? new MultiValueOperand(sanitisedOperands) : originalMulti;
    }

    public Operand visit(SingleValueOperand singleValueOperand) {
        return singleValueOperand;
    }
}

