/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.views.util.IssueViewUtil;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.plugin.issueview.AbstractIssueView;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

public abstract class AbstractIssueHtmlView
extends AbstractIssueView {
    protected final JiraAuthenticationContext authenticationContext;
    protected final ApplicationProperties applicationProperties;
    protected final CommentManager commentManager;
    protected final FieldScreenRendererFactory fieldScreenRendererFactory;
    protected final IssueViewUtil issueViewUtil;
    private final FieldVisibilityManager fieldVisibilityManager;

    public AbstractIssueHtmlView(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, CommentManager commentManager, FieldScreenRendererFactory fieldScreenRendererFactory, IssueViewUtil issueViewUtil, FieldVisibilityManager fieldVisibilityManager) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.commentManager = commentManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.issueViewUtil = issueViewUtil;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    public String getContent(Issue issue, IssueViewRequestParams issueViewRequestParams) {
        return this.getHeader(issue) + this.getBody(issue, issueViewRequestParams) + this.getFooter(issue);
    }

    @Override
    public String getBody(Issue issue, IssueViewRequestParams issueViewFieldParams) {
        AggregateTimeTrackingBean bean;
        ApplicationUser user = this.authenticationContext.getUser();
        boolean timeTrackingEnabled = this.applicationProperties.getOption("jira.option.timetracking");
        boolean subTasksEnabled = this.applicationProperties.getOption("jira.option.allowsubtasks");
        Map<String, Object> bodyParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        bodyParams.put("issue", issue);
        bodyParams.put("i18n", this.authenticationContext.getI18nHelper());
        bodyParams.put("outlookdate", this.authenticationContext.getOutlookDate());
        bodyParams.put("fieldVisibility", this.fieldVisibilityManager);
        bodyParams.put("timeTrackingEnabled", timeTrackingEnabled);
        bodyParams.put("linkingEnabled", this.applicationProperties.getOption("jira.option.issuelinking"));
        bodyParams.put("subtasksEnabled", subTasksEnabled);
        bodyParams.put("linkCollection", this.issueViewUtil.getLinkCollection(issue, user));
        bodyParams.put("fieldScreenRenderer", this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, FieldPredicates.isCustomField()));
        bodyParams.put("votingEnabled", this.applicationProperties.getOption("jira.option.voting"));
        bodyParams.put("wordView", this);
        bodyParams.put("remoteUser", user);
        bodyParams.put("stringUtils", new StringUtils());
        bodyParams.put("encoder", new JiraUrlCodec());
        if (timeTrackingEnabled && subTasksEnabled && !issue.isSubTask() && (bean = this.issueViewUtil.createAggregateBean(issue)).getSubTaskCount() > 0) {
            bodyParams.put("aggregateTimeTrackingBean", this.issueViewUtil.createTimeTrackingBean(bean, this.authenticationContext.getI18nHelper()));
        }
        List comments = this.commentManager.getCommentsForUser(issue, user);
        if (this.applicationProperties.getDefaultBackedString("jira.issue.actions.order").equals("desc")) {
            Collections.reverse(comments);
        }
        bodyParams.put("comments", comments);
        return this.descriptor.getHtml("view", bodyParams);
    }

    public String getHeader(Issue issue) {
        return this.getHeader("[#" + issue.getKey() + "] " + issue.getSummary(), this.getLinkToPrevious(issue));
    }

    protected abstract String getLinkToPrevious(Issue var1);

    public String getHeader(String title, String linkToPrevious) {
        Map<String, Object> bodyParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        bodyParams.put("title", title);
        bodyParams.put("contentType", this.descriptor.getContentType() + "; charset=" + this.applicationProperties.getEncoding());
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        bodyParams.put("linkColour", lookAndFeelBean.getTextLinkColour());
        bodyParams.put("linkAColour", lookAndFeelBean.getTextActiveLinkColour());
        bodyParams.put("showCssLinks", this.printCssLinks() ? Boolean.TRUE : Boolean.FALSE);
        bodyParams.put("linkToPrevious", linkToPrevious);
        bodyParams.put("style", this.getStyleSheetHtml());
        return this.descriptor.getHtml("header", bodyParams);
    }

    protected abstract boolean printCssLinks();

    public String getStyleSheetHtml() {
        return this.descriptor.getHtml("style", new HashMap());
    }

    public String getFooter(Issue issue) {
        Map<String, Object> footerParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        footerParams.put("generatedInfo", SearchRequestViewUtils.getGeneratedInfo(this.authenticationContext.getUser()));
        return this.descriptor.getHtml("footer", footerParams);
    }

    public String getPrettyDuration(Long v) {
        return this.issueViewUtil.getPrettyDuration(v);
    }

    public String getRenderedContent(String fieldName, String value, Issue issue) {
        return this.issueViewUtil.getRenderedContent(fieldName, value, issue);
    }

    public String getCustomFieldHtml(FieldLayoutItem fieldLayoutItem, CustomField field, Issue issue) {
        Action action = null;
        Map displayParams = MapBuilder.newBuilder((Object)"textOnly", (Object)Boolean.TRUE).toMutableMap();
        return field.getViewHtml(fieldLayoutItem, action, issue, displayParams);
    }
}

