/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.statistics.LocalDateFieldSorter;
import com.atlassian.jira.util.LuceneUtils;
import java.util.Comparator;
import java.util.Date;

public class DateFieldSorter
implements LuceneFieldSorter<Date> {
    public static final LuceneFieldSorter<Date> ISSUE_CREATED_STATSMAPPER = new DateFieldSorter("created");
    public static final LuceneFieldSorter<Date> ISSUE_UPDATED_STATSMAPPER = new DateFieldSorter("updated");
    public static final LuceneFieldSorter<LocalDate> ISSUE_DUEDATE_STATSMAPPER = new LocalDateFieldSorter("duedate");
    public static final LuceneFieldSorter<Date> ISSUE_RESOLUTION_DATE_STATSMAPPER = new DateFieldSorter("resolutiondate");
    public static final LuceneFieldSorter<Date> ISSUE_LAST_VIEWED_DATE_STATSMAPPER = new DateFieldSorter("lastViewed");
    private static final Comparator<Date> SIMPLE_COMPARATOR = new SimpleDateComparator();
    private final String documentConstant;

    public DateFieldSorter(String documentConstant) {
        this.documentConstant = documentConstant;
    }

    public String getDocumentConstant() {
        return this.documentConstant;
    }

    public Date getValueFromLuceneField(String documentValue) {
        if (documentValue == null) {
            return null;
        }
        return LuceneUtils.stringToDate((String)documentValue);
    }

    public Comparator<Date> getComparator() {
        return SIMPLE_COMPARATOR;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateFieldSorter that = (DateFieldSorter)o;
        return this.documentConstant != null ? this.documentConstant.equals(that.documentConstant) : that.documentConstant == null;
    }

    public int hashCode() {
        return this.documentConstant != null ? this.documentConstant.hashCode() : 0;
    }

    private static class SimpleDateComparator
    implements Comparator<Date> {
        private SimpleDateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            return o1.compareTo(o2);
        }
    }
}

