/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IssueSecuritySchemeServiceImpl
implements IssueSecuritySchemeService {
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper i18n;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;

    public IssueSecuritySchemeServiceImpl(IssueSecuritySchemeManager issueSecuritySchemeManager, IssueSecurityLevelManager issueSecurityLevelManager, GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager, I18nHelper i18n, ProjectManager projectManager) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
        this.projectManager = projectManager;
    }

    public ServiceOutcome<? extends Collection<IssueSecurityLevelScheme>> getIssueSecurityLevelSchemes(ApplicationUser user) {
        return this.asAdmin(user, () -> ServiceOutcomeImpl.ok(this.issueSecuritySchemeManager.getIssueSecurityLevelSchemes()));
    }

    private boolean canViewSchemeAsProjectAdmin(ApplicationUser user, long schemeId) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.ADMINISTER_PROJECTS, user);
        return !Collections.disjoint(projects, this.issueSecuritySchemeManager.getProjectsUsingScheme(schemeId));
    }

    private boolean canViewProjectAsAdmin(ApplicationUser user, Project project) {
        return project != null && this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
    }

    public ServiceOutcome<IssueSecurityLevelScheme> getIssueSecurityLevelScheme(ApplicationUser user, long schemeId) {
        return this.asAdminOrProjectAdminWithAccessToScheme(user, schemeId, () -> {
            Supplier notFoundSupplier = this.notFoundSupplier("rest.error.issuesecurityscheme.securityscheme.not.found", String.valueOf(schemeId));
            return (ServiceOutcome)Option.option((Object)this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(Long.valueOf(schemeId))).fold(notFoundSupplier, IssueSecuritySchemeServiceImpl.okOutcome());
        });
    }

    public ServiceOutcome<IssueSecurityLevelScheme> getIssueSecurityLevelSchemeForProject(ApplicationUser user, long projectId) {
        return this.getIssueSecurityLevelSchemeForProject(user, (Either<Long, String>)Either.left((Object)projectId));
    }

    public ServiceOutcome<IssueSecurityLevelScheme> getIssueSecurityLevelSchemeForProject(ApplicationUser user, String projectKey) {
        return this.getIssueSecurityLevelSchemeForProject(user, (Either<Long, String>)Either.right((Object)projectKey));
    }

    private ServiceOutcome<IssueSecurityLevelScheme> getIssueSecurityLevelSchemeForProject(ApplicationUser user, Either<Long, String> projectIdOrKey) {
        Supplier notFoundSupplier = this.notFoundSupplier("rest.error.issuesecurityscheme.securitylevel.for.project.not.found", (String)projectIdOrKey.fold(l -> l.toString(), String::toString));
        return this.asAdminOrProjectAdminWithAdminAccessToProject(user, projectIdOrKey, project -> {
            Long schemeIdForProject = this.issueSecuritySchemeManager.getSchemeIdFor(project);
            IssueSecurityLevelScheme issueSecurityLevelScheme = this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(schemeIdForProject);
            return (ServiceOutcome)Option.option((Object)issueSecurityLevelScheme).fold(notFoundSupplier, IssueSecuritySchemeServiceImpl.okOutcome());
        });
    }

    public ServiceOutcome<? extends List<IssueSecurityLevel>> getIssueSecurityLevels(ApplicationUser user, long schemeId) {
        return this.asAdminOrProjectAdminWithAccessToScheme(user, schemeId, () -> {
            Supplier notFoundSupplier = this.notFoundSupplier("rest.error.issuesecurityscheme.securityscheme.not.found", String.valueOf(schemeId));
            return (ServiceOutcome)Option.option((Object)this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(Long.valueOf(schemeId))).fold(notFoundSupplier, securityLevelScheme -> ServiceOutcomeImpl.ok(this.issueSecurityLevelManager.getIssueSecurityLevels(schemeId)));
        });
    }

    public ServiceOutcome<IssueSecurityLevel> getIssueSecurityLevel(ApplicationUser user, long securityLevelId) {
        return this.asAdmin(user, () -> {
            Supplier notFoundSupplier = this.notFoundSupplier("rest.error.issuesecurityscheme.securitylevel.not.found", String.valueOf(securityLevelId));
            return (ServiceOutcome)Option.option((Object)this.issueSecurityLevelManager.getSecurityLevel(securityLevelId)).fold(notFoundSupplier, IssueSecuritySchemeServiceImpl.okOutcome());
        });
    }

    public ServiceOutcome<? extends Collection<IssueSecurityLevelPermission>> getPermissionsByIssueSecurityLevel(ApplicationUser user, long securityLevelId) {
        return this.asAdmin(user, () -> {
            Supplier notFoundSupplier = this.notFoundSupplier("rest.error.issuesecurityscheme.securitylevel.not.found", String.valueOf(securityLevelId));
            return (ServiceOutcome)Option.option((Object)this.issueSecurityLevelManager.getSecurityLevel(securityLevelId)).fold(notFoundSupplier, issueSecurityLevel -> {
                List collection = this.issueSecuritySchemeManager.getPermissionsBySecurityLevel(Long.valueOf(securityLevelId));
                return ServiceOutcomeImpl.ok(collection);
            });
        });
    }

    private static <T> Function<T, ServiceOutcome<T>> okOutcome() {
        return ServiceOutcomeImpl::ok;
    }

    private <T> Supplier<ServiceOutcome<T>> notFoundSupplier(String i18nKey, String ... params) {
        return () -> ServiceOutcomeImpl.error(this.i18n.getText(i18nKey, (Object)params), ErrorCollection.Reason.NOT_FOUND);
    }

    private boolean isAdmin(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private <T> ServiceOutcome<T> asAdmin(ApplicationUser user, ServiceAction<T> action) {
        return this.performActionWithUserPermissionCondition(user, () -> this.isAdmin(user), action);
    }

    private <T> ServiceOutcome<T> asAdminOrProjectAdminWithAccessToScheme(ApplicationUser user, Long schemeId, ServiceAction<T> action) {
        return this.performActionWithUserPermissionCondition(user, () -> this.isAdmin(user) || this.canViewSchemeAsProjectAdmin(user, schemeId), action);
    }

    private <T> ServiceOutcome<T> asAdminOrProjectAdminWithAdminAccessToProject(ApplicationUser user, Either<Long, String> projectIdOrKey, Function<Project, ServiceOutcome<T>> action) {
        Project project = (Project)projectIdOrKey.fold(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0), arg_0 -> ((ProjectManager)this.projectManager).getProjectObjByKey(arg_0));
        if (project == null) {
            return ServiceOutcomeImpl.error(this.i18n.getText("admin.errors.portal.project.nonexist"), ErrorCollection.Reason.NOT_FOUND);
        }
        return this.performActionWithUserPermissionCondition(user, () -> this.isAdmin(user) || this.canViewProjectAsAdmin(user, project), () -> (ServiceOutcome)action.apply((Object)project));
    }

    private <T> ServiceOutcome<T> performActionWithUserPermissionCondition(ApplicationUser user, ParameterlessPredicate predicate, ServiceAction<T> action) {
        String forbiddenMessage = this.i18n.getText("admin.schemes.permissions.forbidden");
        if (user == null) {
            return ServiceOutcomeImpl.error(forbiddenMessage, ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        if (!predicate.apply()) {
            return ServiceOutcomeImpl.error(forbiddenMessage, ErrorCollection.Reason.FORBIDDEN);
        }
        return action.perform();
    }

    private static interface ParameterlessPredicate {
        public boolean apply();
    }

    private static interface ServiceAction<T> {
        public ServiceOutcome<T> perform();
    }
}

