/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.IssueFieldsCharacterLimitExceededException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueTextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.IssueUtils;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.issue.comparator.IssueKeyComparator;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.managers.IssueDeleteHelper;
import com.atlassian.jira.issue.search.parameters.filter.NoBrowsePermissionPredicate;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueManager
implements IssueManager {
    private static final String ISSUE_MAP_KEY = "issue";
    private final OfBizDelegator ofBizDelegator;
    private final WorkflowManager workflowManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final UserAssociationStore userAssociationStore;
    private final IssueUpdater issueUpdater;
    private IssueDeleteHelper issueDeleteHelper;
    private FieldManager fieldManager;
    private FieldLayoutManager fieldLayoutManager;
    private final PermissionManager permissionManager;
    private final MovedIssueKeyStore movedIssueKeyStore;
    private final ProjectKeyStore projectKeyStore;
    private final Map<String, Object> unassignedCondition = Collections.singletonMap("assignee", null);
    private final IssueTextFieldCharacterLengthValidator issueTextFieldCharacterLengthValidator;
    private final IssueFinder issueFinder = new IssueFinder(){

        @Override
        protected Long getProjectByKey(String projectKey) {
            return DefaultIssueManager.this.projectKeyStore.getProjectId(projectKey);
        }
    };
    private final IssueFinder caseInsensitiveIssueFinder = new IssueFinder(){

        @Override
        protected Long getProjectByKey(String projectKey) {
            return DefaultIssueManager.this.projectKeyStore.getProjectIdByKeyIgnoreCase(projectKey);
        }
    };

    public DefaultIssueManager(OfBizDelegator ofBizDelegator, WorkflowManager workflowManager, NodeAssociationStore nodeAssociationStore, UserAssociationStore userAssociationStore, IssueUpdater issueUpdater, PermissionManager permissionManager, MovedIssueKeyStore movedIssueKeyStore, ProjectKeyStore projectKeyStore, IssueTextFieldCharacterLengthValidator issueTextFieldCharacterLengthValidator) {
        this.ofBizDelegator = ofBizDelegator;
        this.workflowManager = workflowManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.userAssociationStore = userAssociationStore;
        this.issueUpdater = issueUpdater;
        this.permissionManager = permissionManager;
        this.movedIssueKeyStore = movedIssueKeyStore;
        this.projectKeyStore = projectKeyStore;
        this.issueTextFieldCharacterLengthValidator = issueTextFieldCharacterLengthValidator;
    }

    public GenericValue getIssue(Long id) throws DataAccessException {
        if (id == null) {
            return null;
        }
        return this.ofBizDelegator.findById("Issue", id);
    }

    public GenericValue getIssue(String key) throws GenericEntityException {
        return this.getIssueFinder().getIssue(key);
    }

    public boolean isExistingIssueKey(String issueKey) throws GenericEntityException {
        return this.getIssue(issueKey) != null;
    }

    public List<GenericValue> getIssues(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityExpr> entityExpressions = new ArrayList<EntityExpr>();
        List unsortedIssues = null;
        int batchSize = DefaultOfBizDelegator.getQueryBatchSize();
        int i = 0;
        for (Long issueId : ids) {
            entityExpressions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)issueId));
            if (++i < batchSize) continue;
            if (unsortedIssues == null) {
                unsortedIssues = this.ofBizDelegator.findByOr("Issue", entityExpressions, null);
            } else {
                unsortedIssues.addAll(this.ofBizDelegator.findByOr("Issue", entityExpressions, null));
            }
            entityExpressions = new ArrayList();
            i = 0;
        }
        if (!entityExpressions.isEmpty()) {
            if (unsortedIssues == null) {
                unsortedIssues = this.ofBizDelegator.findByOr("Issue", entityExpressions, null);
            } else {
                unsortedIssues.addAll(this.ofBizDelegator.findByOr("Issue", entityExpressions, null));
            }
        }
        return this.getIssuesSortedByIds(unsortedIssues, ids);
    }

    public List<Issue> getIssueObjects(Collection<Long> ids) {
        ArrayList<Issue> issues = new ArrayList<Issue>(ids.size());
        for (GenericValue gv : this.getIssues(ids)) {
            if (gv == null) continue;
            issues.add((Issue)DefaultIssueManager.getIssueFactory().getIssue(gv));
        }
        return issues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getIssueIdsForProject(Long projectId) throws GenericEntityException {
        if (projectId == null) {
            throw new NullPointerException("Project Id cannot be null.");
        }
        ArrayList<Long> issueIds = new ArrayList<Long>();
        try (OfBizListIterator issueIterator = null;){
            issueIterator = this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)projectId), EntityOperator.AND), null, (Collection)ImmutableList.of((Object)"id"), null, null);
            GenericValue issueIdGV = issueIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("id"));
                issueIdGV = issueIterator.next();
            }
        }
        return issueIds;
    }

    public long getIssueCountForProject(Long projectId) {
        Assertions.notNull((String)"projectId", (Object)projectId);
        EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)projectId), EntityOperator.AND);
        GenericValue countGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByCondition("IssueCount", (EntityCondition)condition, Collections.singletonList("count"), Collections.emptyList()));
        long count = countGV.getLong("count");
        return count;
    }

    public boolean hasUnassignedIssues() {
        try (OfBizListIterator unassignedIssuesIt = this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)new EntityFieldMap(this.unassignedCondition, EntityOperator.EQUALS), null, (Collection)ImmutableList.of((Object)"id"), (List)ImmutableList.of((Object)"id"), EntityFindOptions.findOptions().maxResults(1));){
            boolean bl = unassignedIssuesIt.next() != null;
            return bl;
        }
    }

    public long getUnassignedIssueCount() {
        List unassignedCount = this.ofBizDelegator.findByCondition("IssueCountByAssignee", (EntityCondition)new EntityFieldMap(this.unassignedCondition, EntityOperator.EQUALS), (Collection)ImmutableList.of((Object)"count"), null);
        return EntityUtil.getOnly((List)unassignedCount).getLong("count");
    }

    public long getIssueCount() {
        try {
            return this.ofBizDelegator.getDelegatorInterface().countAll("Issue");
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean atLeastOneIssueExists() {
        try (OfBizListIterator iterator = null;){
            iterator = this.ofBizDelegator.findListIteratorByCondition("Issue", null, null, (Collection)ImmutableList.of((Object)"id"), (List)ImmutableList.of((Object)"id"), EntityFindOptions.findOptions().maxResults(1));
            boolean bl = iterator.next() != null;
            return bl;
        }
    }

    public final Issue findMovedIssue(String originalKey) {
        Assertions.notNull((String)"originalKey", (Object)originalKey);
        String key = originalKey.toUpperCase();
        Long issueId = this.movedIssueKeyStore.getMovedIssueId(key);
        if (issueId != null) {
            return this.getIssueObject(issueId);
        }
        return null;
    }

    public void recordMovedIssueKey(Issue oldIssue) {
        Set<String> projectKeys = this.projectKeyStore.getProjectKeys(oldIssue.getProjectId());
        for (String projectKey : projectKeys) {
            String oldIssueKey = IssueKey.format((String)projectKey, (long)oldIssue.getNumber());
            this.movedIssueKeyStore.recordMovedIssueKey(oldIssueKey, oldIssue.getId());
        }
    }

    private List<GenericValue> getIssuesSortedByIds(Collection<GenericValue> unsortedIssues, Collection<Long> ids) {
        HashMap<Long, GenericValue> idToIssue = new HashMap<Long, GenericValue>();
        for (GenericValue issue : unsortedIssues) {
            idToIssue.put(issue.getLong("id"), issue);
        }
        ArrayList<GenericValue> sortedIssues = new ArrayList<GenericValue>(ids.size());
        for (Long id : ids) {
            sortedIssues.add((GenericValue)idToIssue.get(id));
        }
        return sortedIssues;
    }

    public GenericValue getIssueByWorkflow(Long wfid) throws GenericEntityException {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Issue", (Map)FieldMap.build((String)"workflowId", (Object)wfid)));
    }

    public MutableIssue getIssueObjectByWorkflow(Long workflowId) throws GenericEntityException {
        return this.getIssueObject(this.getIssueByWorkflow(workflowId));
    }

    public MutableIssue getIssueObject(Long id) throws DataAccessException {
        GenericValue issueGV = this.getIssue(id);
        if (issueGV == null) {
            return null;
        }
        return this.getIssueObject(issueGV);
    }

    public MutableIssue getIssueObject(String key) throws DataAccessException {
        try {
            GenericValue issueGV = this.getIssue(key);
            if (issueGV == null) {
                return null;
            }
            return this.getIssueObject(issueGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public MutableIssue getIssueByKeyIgnoreCase(String key) throws DataAccessException {
        try {
            GenericValue issueGV = this.getCaseInsensitiveIssueFinder().getIssue(key);
            if (issueGV == null) {
                return null;
            }
            return this.getIssueObject(issueGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public MutableIssue getIssueByCurrentKey(String key) throws DataAccessException {
        GenericValue issue;
        try {
            issue = this.getIssueFinder().getIssue(key);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        if (issue != null && issue.getString("key").equals(key)) {
            return this.getIssueObject(issue);
        }
        return null;
    }

    public List<GenericValue> getEntitiesByIssue(String relationName, GenericValue issue) throws GenericEntityException {
        if (relationName.equals("IssueComponent")) {
            return this.nodeAssociationStore.getSinksFromSource(issue, "Component", relationName);
        }
        if (relationName.equals("IssueFixVersion")) {
            return this.nodeAssociationStore.getSinksFromSource(issue, "Version", relationName);
        }
        if (relationName.equals("IssueVersion")) {
            return this.nodeAssociationStore.getSinksFromSource(issue, "Version", relationName);
        }
        if (relationName.equals("IssueChangeGroups")) {
            return issue.getRelatedCache("ChildChangeGroup");
        }
        if (relationName.equals("IssueWorkflowHistory")) {
            return this.workflowManager.makeWorkflowWithUserKey(null).getHistorySteps(issue.getLong("workflowId").longValue());
        }
        if (relationName.equals("IssueComments")) {
            return issue.getRelatedByAnd("ChildAction", MapBuilder.build((Object)"type", (Object)"comment"));
        }
        if (relationName.equals("IssueWorklog")) {
            return issue.getRelated("ChildWorklog");
        }
        if (relationName.equals("IssueLinksInward")) {
            return this.ofBizDelegator.findByAnd("IssueLink", MapBuilder.build((Object)"destination", (Object)issue.getLong("id")));
        }
        if (relationName.equals("IssueLinksOutward")) {
            return this.ofBizDelegator.findByAnd("IssueLink", MapBuilder.build((Object)"source", (Object)issue.getLong("id")));
        }
        if (relationName.equals("IssueCustomFieldValues")) {
            return this.ofBizDelegator.findByAnd("CustomFieldValue", MapBuilder.build((Object)ISSUE_MAP_KEY, (Object)issue.getLong("id")));
        }
        return Collections.emptyList();
    }

    public List<GenericValue> getEntitiesByIssueObject(String relationName, Issue issue) throws GenericEntityException {
        return this.getEntitiesByIssue(relationName, issue.getGenericValue());
    }

    public List<GenericValue> getIssuesByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        return this.nodeAssociationStore.getSourcesFromSink(entity, "Issue", relationName);
    }

    public List<Issue> getIssueObjectsByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        return this.getIssuesByEntity(relationName, entity).stream().map(gv -> DefaultIssueManager.getIssueFactory().getIssue(gv)).collect(Collectors.toList());
    }

    public Set<String> getAllIssueKeys(Long issueId) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        MutableIssue issue = this.getIssueObject(issueId);
        Project project = issue.getProjectObject();
        Set<String> projectKeys = this.projectKeyStore.getProjectKeys(project.getId());
        return ImmutableSet.builder().addAll(this.getPreviousIssueKeysForMovedIssues(issueId)).addAll(Iterables.transform(projectKeys, (Function)new Function<String, String>((Issue)issue){
            final /* synthetic */ Issue val$issue;
            {
                this.val$issue = issue;
            }

            public String apply(String projectKey) {
                return IssueKey.format((String)projectKey, (long)this.val$issue.getNumber());
            }
        })).build();
    }

    private Collection<String> getPreviousIssueKeysForMovedIssues(Long issueId) {
        try {
            EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"issueId", (Object)issueId), EntityOperator.AND);
            List gvs = this.ofBizDelegator.findByCondition("MovedIssueKey", (EntityCondition)condition, (Collection)ImmutableList.of((Object)"oldIssueKey"), (List)ImmutableList.of((Object)"id"));
            return this.collectPreviousIssueKeys(gvs);
        }
        catch (DataAccessException e) {
            return Collections.emptySet();
        }
    }

    private Collection<String> collectPreviousIssueKeys(List<GenericValue> issueChangeItemIteratorGVs) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (GenericValue issueChangeItemIteratorGV : issueChangeItemIteratorGVs) {
            result.add(issueChangeItemIteratorGV.getString("oldIssueKey"));
        }
        return result;
    }

    public GenericValue createIssue(ApplicationUser remoteUser, Map<String, Object> fields) throws CreateException {
        return this.createIssue(remoteUser != null ? remoteUser.getName() : null, fields);
    }

    public GenericValue createIssue(ApplicationUser remoteUser, Issue issue) throws CreateException {
        this.validateCreateIssueTextFieldsLength(issue);
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put(ISSUE_MAP_KEY, issue);
            MutableIssue originalIssueGV = this.getIssueObject(issue.getId());
            fields.put("originalissueobject", originalIssueGV);
            GenericValue issueGV = this.workflowManager.createIssue(remoteUser != null ? remoteUser.getName() : null, fields);
            return issueGV;
        }
        catch (WorkflowException workflowException) {
            Throwable cause = workflowException.getCause();
            if (cause instanceof InvalidInputException) {
                throw new CreateException("Error occurred while creating issue through workflow: " + cause.getMessage(), (Exception)((Object)((InvalidInputException)cause)));
            }
            throw new CreateException((Exception)((Object)workflowException));
        }
    }

    private void validateCreateIssueTextFieldsLength(Issue issue) {
        IssueTextFieldCharacterLengthValidator.ValidationResult validationResult = this.issueTextFieldCharacterLengthValidator.validateAllFields(issue);
        if (!validationResult.isValid()) {
            throw new IssueFieldsCharacterLimitExceededException(validationResult.getInvalidFieldIds(), validationResult.getMaximumNumberOfCharacters());
        }
    }

    private void validateUpdateIssueTextFieldsLength(MutableIssue issue) {
        IssueTextFieldCharacterLengthValidator.ValidationResult validationResult = this.issueTextFieldCharacterLengthValidator.validateModifiedFields(issue);
        if (!validationResult.isValid()) {
            throw new IssueFieldsCharacterLimitExceededException(validationResult.getInvalidFieldIds(), validationResult.getMaximumNumberOfCharacters());
        }
    }

    public List<GenericValue> getProjectIssues(GenericValue project) throws GenericEntityException {
        return project.getRelated("ChildIssue");
    }

    public boolean isEditable(Issue issue) {
        return this.workflowManager.isEditable(issue);
    }

    public boolean isEditable(Issue issue, ApplicationUser user) {
        return this.isEditable(issue) && this.permissionManager.hasPermission(12, issue, user);
    }

    public GenericValue createIssue(String remoteUserName, Map<String, Object> fields) throws CreateException {
        Issue issue;
        Object issueObject = fields.get(ISSUE_MAP_KEY);
        if (issueObject instanceof Issue) {
            issue = (Issue)issueObject;
            this.validateCreateIssueTextFieldsLength(issue);
        }
        try {
            issue = this.workflowManager.createIssue(remoteUserName, fields);
            return issue;
        }
        catch (WorkflowException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof InvalidInputException) {
                throw new CreateException("Error occurred while creating issue through workflow: " + cause.getMessage(), (Exception)((Object)((InvalidInputException)cause)));
            }
            throw new CreateException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Issue createIssueObject(String remoteUserName, Map<String, Object> fields) throws CreateException {
        return DefaultIssueManager.getIssueFactory().getIssue(this.createIssue(remoteUserName, fields));
    }

    public Issue createIssueObject(ApplicationUser remoteUser, Map<String, Object> fields) throws CreateException {
        return DefaultIssueManager.getIssueFactory().getIssue(this.createIssue(remoteUser, fields));
    }

    public Issue createIssueObject(ApplicationUser remoteUser, Issue issue) throws CreateException {
        return DefaultIssueManager.getIssueFactory().getIssue(this.createIssue(remoteUser, issue));
    }

    public List<Issue> getVotedIssues(ApplicationUser user) {
        List<Issue> votedIssues = this.getVotedIssuesOverrideSecurity(user);
        IssueUtils.filterIssues(votedIssues, new NoBrowsePermissionPredicate(user));
        return votedIssues;
    }

    public List<Issue> getVotedIssuesOverrideSecurity(ApplicationUser user) {
        List<GenericValue> issueGVs = this.userAssociationStore.getSinksFromUser("VoteIssue", user, "Issue");
        return this.getIssueObjectsFromGVs(issueGVs);
    }

    private List<Issue> getIssueObjectsFromGVs(List<GenericValue> issueGVs) {
        Collections.sort(issueGVs, IssueKeyComparator.COMPARATOR);
        ArrayList<Issue> issues = new ArrayList<Issue>(issueGVs.size());
        for (GenericValue issue : issueGVs) {
            issues.add((Issue)this.getIssueObject(issue));
        }
        return issues;
    }

    public List<ApplicationUser> getWatchers(Issue issue) {
        return this.getWatchersFor(issue);
    }

    public List<ApplicationUser> getWatchersFor(Issue issue) {
        return this.userAssociationStore.getUsersFromSink("WatchIssue", issue.getGenericValue());
    }

    public List<Issue> getWatchedIssues(ApplicationUser user) {
        List<Issue> watchedIssues = this.getWatchedIssuesOverrideSecurity(user);
        IssueUtils.filterIssues(watchedIssues, new NoBrowsePermissionPredicate(user));
        return watchedIssues;
    }

    public List<Issue> getWatchedIssuesOverrideSecurity(ApplicationUser user) {
        List<GenericValue> issueGVs = this.userAssociationStore.getSinksFromUser("WatchIssue", user, "Issue");
        return this.getIssueObjectsFromGVs(issueGVs);
    }

    public Issue updateIssue(ApplicationUser user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) {
        return this.updateIssue(user, issue, UpdateIssueRequest.builder().eventDispatchOption(eventDispatchOption).sendMail(sendMail).build());
    }

    public Issue updateIssue(ApplicationUser user, MutableIssue issue, UpdateIssueRequest updateIssueRequest) {
        this.validateUpdateIssueTextFieldsLength(issue);
        GenericValue originalIssueGV = issue.getGenericValue();
        DefaultIssueChangeHolder issueChangeHolder = this.updateFieldValues(issue, new StringBuffer());
        issue.resetModifiedFields();
        this.doUpdate(user, issue, originalIssueGV, issueChangeHolder, updateIssueRequest);
        return issue;
    }

    protected void doUpdate(ApplicationUser user, MutableIssue issue, GenericValue originalIssueGV, DefaultIssueChangeHolder issueChangeHolder, UpdateIssueRequest updateRequest) {
        EventDispatchOption dispatchOption = updateRequest.getEventDispatchOption();
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue.getGenericValue(), originalIssueGV, dispatchOption.getEventTypeId(), user, updateRequest.isSendMail(), true);
        issueUpdateBean.setComment(issueChangeHolder.getComment());
        issueUpdateBean.setChangeItems((Collection)issueChangeHolder.getChangeItems());
        issueUpdateBean.setDispatchEvent(dispatchOption.isEventBeingSent());
        issueUpdateBean.setHistoryMetadata(updateRequest.getHistoryMetadata());
        issueUpdateBean.setParams(MapBuilder.newBuilder((Object)"eventsource", (Object)"action").toMutableMap());
        this.issueUpdater.doUpdate(issueUpdateBean, false);
    }

    protected DefaultIssueChangeHolder updateFieldValues(MutableIssue issue, StringBuffer ignored) {
        DefaultIssueChangeHolder issueChangeHolder = new DefaultIssueChangeHolder();
        Map modifiedFields = issue.getModifiedFields();
        for (String fieldId : modifiedFields.keySet()) {
            if (!this.getFieldManager().isOrderableField(fieldId)) continue;
            OrderableField field = this.getFieldManager().getOrderableField(fieldId);
            FieldLayoutItem fieldLayoutItem = this.getFieldLayoutManager().getFieldLayout((Issue)issue).getFieldLayoutItem(field);
            ModifiedValue modifiedValue = (ModifiedValue)modifiedFields.get(fieldId);
            field.updateValue(fieldLayoutItem, (Issue)issue, modifiedValue, (IssueChangeHolder)issueChangeHolder);
        }
        return issueChangeHolder;
    }

    public void deleteIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssue(user, issue, eventDispatchOption, sendMail);
    }

    public void deleteIssue(ApplicationUser user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssue(user, (Issue)issue, eventDispatchOption, sendMail);
    }

    public void deleteIssueNoEvent(Issue issue) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssueNoEvent(issue);
    }

    public void deleteIssueNoEvent(MutableIssue issue) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssueNoEvent((Issue)issue);
    }

    @VisibleForTesting
    protected MutableIssue getIssueObject(GenericValue issueGV) {
        if (issueGV == null) {
            return null;
        }
        return DefaultIssueManager.getIssueFactory().getIssue(issueGV);
    }

    private static IssueFactory getIssueFactory() {
        return ComponentAccessor.getIssueFactory();
    }

    FieldLayoutManager getFieldLayoutManager() {
        if (this.fieldLayoutManager == null) {
            this.fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        }
        return this.fieldLayoutManager;
    }

    FieldManager getFieldManager() {
        if (this.fieldManager == null) {
            this.fieldManager = ComponentAccessor.getFieldManager();
        }
        return this.fieldManager;
    }

    IssueDeleteHelper getIssueDeleteHelper() {
        if (this.issueDeleteHelper == null) {
            this.issueDeleteHelper = (IssueDeleteHelper)ComponentAccessor.getComponentOfType(IssueDeleteHelper.class);
        }
        return this.issueDeleteHelper;
    }

    @VisibleForTesting
    IssueFinder getIssueFinder() {
        return this.issueFinder;
    }

    @VisibleForTesting
    IssueFinder getCaseInsensitiveIssueFinder() {
        return this.caseInsensitiveIssueFinder;
    }

    private Pair<Set<String>, Map<String, Set<Long>>> breakDownIssueKeys(@Nonnull Set<String> issueKeys) {
        HashSet<String> invalidKeys = new HashSet<String>();
        HashMap<String, HashSet<Long>> projectKeyIssueNumbers = new HashMap<String, HashSet<Long>>();
        for (String issueKey : issueKeys) {
            IssueKey issueKeyObject;
            try {
                issueKeyObject = IssueKey.from((String)issueKey);
            }
            catch (IllegalArgumentException ex) {
                invalidKeys.add(issueKey);
                continue;
            }
            HashSet<Long> issueNumbers = (HashSet<Long>)projectKeyIssueNumbers.get(issueKeyObject.getProjectKey());
            if (issueNumbers == null) {
                issueNumbers = new HashSet<Long>();
                projectKeyIssueNumbers.put(issueKeyObject.getProjectKey(), issueNumbers);
            }
            issueNumbers.add(issueKeyObject.getIssueNumber());
        }
        return Pair.of(invalidKeys, projectKeyIssueNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Pair<Long, String>> getProjectIssueTypePairs(@Nonnull Collection<String> fields, @Nonnull EntityCondition condition) {
        try (OfBizListIterator iterator = null;){
            iterator = this.ofBizDelegator.findListIteratorByCondition("Issue", condition, null, fields, null, null);
            HashSet<Pair<Long, String>> projectIssueTypes = new HashSet<Pair<Long, String>>();
            GenericValue genericValue = iterator.next();
            while (genericValue != null) {
                Long projectId = genericValue.getLong("project");
                String issueTypeId = genericValue.getString("type");
                projectIssueTypes.add((Pair<Long, String>)Pair.of((Object)projectId, (Object)issueTypeId));
                genericValue = iterator.next();
            }
            HashSet<Pair<Long, String>> hashSet = projectIssueTypes;
            return hashSet;
        }
    }

    @Nonnull
    public Set<Pair<Long, String>> getProjectIssueTypePairsByKeys(@Nonnull Set<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return new HashSet<Pair<Long, String>>();
        }
        UtilTimerStack.push((String)"DefaultIssueManager.getProjectIssueTypePairsByKeys()");
        Pair<Set<String>, Map<String, Set<Long>>> result = this.breakDownIssueKeys(issueKeys);
        Map projectIssueNumbers = (Map)result.second();
        HashSet<Pair<Long, String>> projectIssueTypes = new HashSet<Pair<Long, String>>();
        for (Map.Entry entry : projectIssueNumbers.entrySet()) {
            Long projectId = this.projectKeyStore.getProjectId((String)entry.getKey());
            if (projectId == null) continue;
            EntityExpr projectIdCondition = new EntityExpr("project", EntityOperator.EQUALS, (Object)projectId);
            EntityExpr issueNumberCondition = new EntityExpr("number", EntityOperator.IN, entry.getValue());
            EntityConditionList conditions = new EntityConditionList(Arrays.asList(projectIdCondition, issueNumberCondition), EntityOperator.AND);
            projectIssueTypes.addAll(this.getProjectIssueTypePairs(Arrays.asList("project", "type"), (EntityCondition)conditions));
        }
        UtilTimerStack.pop((String)"DefaultIssueManager.getProjectIssueTypePairsByKeys()");
        return projectIssueTypes;
    }

    @Nonnull
    public Set<Pair<Long, String>> getProjectIssueTypePairsByIds(@Nonnull Set<Long> issueIds) {
        if (issueIds.isEmpty()) {
            return new HashSet<Pair<Long, String>>();
        }
        UtilTimerStack.push((String)"DefaultIssueManager.getProjectIssueTypePairsByIds()");
        EntityExpr condition = new EntityExpr("id", EntityOperator.IN, issueIds);
        Set<Pair<Long, String>> projectIssueTypePairsByIds = this.getProjectIssueTypePairs(Arrays.asList("project", "type"), (EntityCondition)condition);
        UtilTimerStack.pop((String)"DefaultIssueManager.getProjectIssueTypePairsByIds()");
        return projectIssueTypePairsByIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> Set<E> checkIssuesExist(@Nonnull Set<E> allItems, @Nonnull Collection<String> fields, EntityCondition condition, @Nonnull Function<GenericValue, E> function) {
        HashSet<E> missingItems = new HashSet<E>();
        try (OfBizListIterator iterator = null;){
            iterator = this.ofBizDelegator.findListIteratorByCondition("Issue", condition, null, fields, null, null);
            missingItems.addAll(allItems);
            UtilTimerStack.push((String)"DefaultIssueManager.checkIssuesExist()");
            GenericValue genericValue = iterator.next();
            while (genericValue != null) {
                Object issueId = function.apply((Object)genericValue);
                missingItems.remove(issueId);
                genericValue = iterator.next();
            }
            UtilTimerStack.pop((String)"DefaultIssueManager.checkIssuesExist()");
        }
        return missingItems;
    }

    @Nonnull
    public Set<String> getKeysOfMissingIssues(@Nonnull Set<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return new HashSet<String>();
        }
        UtilTimerStack.push((String)"DefaultIssueManager.getKeysOfMissingIssues()");
        Pair<Set<String>, Map<String, Set<Long>>> result = this.breakDownIssueKeys(issueKeys);
        Set invalidIssueKeys = (Set)result.first();
        Map projectIssueNumbers = (Map)result.second();
        HashSet<String> missingIssueKeys = new HashSet<String>(invalidIssueKeys);
        for (Map.Entry entry : projectIssueNumbers.entrySet()) {
            HashSet<String> missingIssueKeysForThisProject = new HashSet<String>();
            final String projectKey = (String)entry.getKey();
            HashSet<String> issueKeysForThisProject = new HashSet<String>();
            for (Long issueKey : (Set)entry.getValue()) {
                issueKeysForThisProject.add(new IssueKey(projectKey, issueKey.longValue()).toString());
            }
            Long projectId = this.projectKeyStore.getProjectId((String)entry.getKey());
            if (projectId == null) {
                missingIssueKeysForThisProject.addAll(issueKeysForThisProject);
                continue;
            }
            EntityExpr projectIdCondition = new EntityExpr("project", EntityOperator.EQUALS, (Object)projectId);
            EntityExpr issueNumberCondition = new EntityExpr("number", EntityOperator.IN, entry.getValue());
            EntityConditionList conditions = new EntityConditionList(Arrays.asList(projectIdCondition, issueNumberCondition), EntityOperator.AND);
            missingIssueKeysForThisProject.addAll(this.checkIssuesExist(issueKeysForThisProject, Arrays.asList("id", "number"), (EntityCondition)conditions, new Function<GenericValue, String>(){

                public String apply(@Nonnull GenericValue genericValue) {
                    return new IssueKey(projectKey, genericValue.getLong("number").longValue()).toString();
                }
            }));
            Set<String> movedIssueKeys = this.movedIssueKeyStore.getMovedIssueKeys(missingIssueKeysForThisProject);
            missingIssueKeysForThisProject.removeAll(movedIssueKeys);
            missingIssueKeys.addAll(missingIssueKeysForThisProject);
        }
        UtilTimerStack.pop((String)"DefaultIssueManager.getKeysOfMissingIssues()");
        return missingIssueKeys;
    }

    @Nonnull
    public Set<Long> getIdsOfMissingIssues(@Nonnull Set<Long> issueIds) {
        if (issueIds.isEmpty()) {
            return new HashSet<Long>();
        }
        UtilTimerStack.push((String)"DefaultIssueManager.getIdsOfMissingIssues()");
        EntityExpr condition = new EntityExpr("id", EntityOperator.IN, issueIds);
        Set<Long> missingIssueIds = this.checkIssuesExist(issueIds, Arrays.asList("id"), (EntityCondition)condition, new Function<GenericValue, Long>(){

            public Long apply(@Nonnull GenericValue genericValue) {
                return genericValue.getLong("id");
            }
        });
        UtilTimerStack.pop((String)"DefaultIssueManager.getIdsOfMissingIssues()");
        return missingIssueIds;
    }

    abstract class IssueFinder {
        IssueFinder() {
        }

        public GenericValue getIssue(String key) throws GenericEntityException {
            if (key == null) {
                return null;
            }
            GenericValue issue = this.getIssueFromIssueEntity(key);
            if (issue == null) {
                Issue movedIssue = DefaultIssueManager.this.findMovedIssue(key);
                if (movedIssue == null) {
                    return null;
                }
                return movedIssue.getGenericValue();
            }
            return issue;
        }

        private GenericValue getIssueFromIssueEntity(String key) {
            IssueKey issueKey;
            try {
                issueKey = IssueKey.from((String)key);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            Long projectId = this.getProjectByKey(issueKey.getProjectKey());
            if (projectId == null) {
                return null;
            }
            return this.getIssueFromIssueEntityByProjectAndNumber(projectId, issueKey.getIssueNumber());
        }

        private GenericValue getIssueFromIssueEntityByProjectAndNumber(Long projectId, Long issueNumber) {
            return EntityUtil.getOnly((List)DefaultIssueManager.this.ofBizDelegator.findByAnd("Issue", (Map)ImmutableMap.of((Object)"project", (Object)projectId, (Object)"number", (Object)issueNumber)));
        }

        protected abstract Long getProjectByKey(String var1);
    }
}

