/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class ProjectCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;
    private final ProjectConverter projectConverter;

    public ProjectCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, ProjectConverter projectConverter) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.projectConverter = projectConverter;
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        Object value = this.customField.getValue(issue);
        if (value != null) {
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), this.projectConverter.getString((Project)value), Field.Store.YES, indexType));
        }
    }
}

